/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import ro.atreides.utils.FileUtils;

public class ZipUtils {
    public static void zipUnpack(String file, String destinationFolder) throws IOException {
        BufferedInputStream buf = new BufferedInputStream(new FileInputStream(file));
        ZipInputStream zis = new ZipInputStream(buf);
        boolean stop = false;
        while (!stop) {
            ZipEntry ze = zis.getNextEntry();
            if (ze == null) {
                stop = true;
                continue;
            }
            String name = ze.getName();
            if (ze.isDirectory()) {
                new File(destinationFolder + File.separator + name).mkdirs();
                continue;
            }
            FileOutputStream out = new FileOutputStream(destinationFolder + File.separator + name);
            FileUtils.copyFiles(zis, out);
            out.close();
        }
    }

    public static void zipCreate(File[] files, OutputStream out, String parent) throws IOException {
        byte[] b = new byte[512];
        ZipOutputStream zout = new ZipOutputStream(out);
        for (int i = 0; i < files.length; ++i) {
            FileInputStream in = new FileInputStream(files[i]);
            ZipEntry e = new ZipEntry(parent + "/" + files[i].getName());
            zout.putNextEntry(e);
            int len = 0;
            while ((len = ((InputStream)in).read(b)) != -1) {
                zout.write(b, 0, len);
            }
            zout.closeEntry();
        }
        zout.close();
    }

    public static void print(ZipEntry e) {
        PrintStream err = System.err;
        err.print("added " + e.getName());
        if (e.getMethod() == 8) {
            long size = e.getSize();
            if (size > 0L) {
                long csize = e.getCompressedSize();
                long ratio = (size - csize) * 100L / size;
                err.println(" (deflated " + ratio + "%)");
            } else {
                err.println(" (deflated 0%)");
            }
        } else {
            err.println(" (stored 0%)");
        }
    }

    public static void zipCreateRecursive(File[] files, String dest) throws IOException {
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(dest));
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            ZipUtils.addToZipRecursive("", file, out);
        }
        out.flush();
        out.close();
    }

    public static void zipCreateRecursive(String sourceFile, String dest) throws IOException {
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(dest));
        File file = new File(sourceFile);
        if (file.exists()) {
            ZipUtils.addToZipRecursive("", file, out);
        }
        out.flush();
        out.close();
    }

    private static void addToZipRecursive(String zipPath, File file, ZipOutputStream out) throws IOException {
        String path;
        String string = path = zipPath.equals("") ? file.getName() : zipPath + "/" + file.getName();
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                ZipUtils.addToZipRecursive(path, files[i], out);
            }
        } else if (file.isFile()) {
            ZipUtils.addToZip(path, file, out);
        }
    }

    private static void addToZip(String zipPath, File file, ZipOutputStream out) throws IOException {
        FileInputStream in = new FileInputStream(file);
        out.putNextEntry(new ZipEntry(zipPath));
        FileUtils.copyFiles(in, out);
        in.close();
    }

    public static void zipUnpackRecursive(String file, String destinationDir) throws IOException {
        if (!new File(file).exists()) {
            return;
        }
        ZipFile zf = new ZipFile(file);
        File destFolder = new File(destinationDir);
        if (!destFolder.exists()) {
            destFolder.mkdirs();
        }
        byte[] buf = new byte[102400];
        Enumeration<? extends ZipEntry> e = zf.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            String name = ze.getName();
            ZipUtils.createDirsForZipIfNedeed(destinationDir, name);
            String dest = destinationDir + File.separator + name;
            if (!ze.isDirectory()) {
                int len;
                FileOutputStream fout = new FileOutputStream(dest);
                InputStream in = zf.getInputStream(ze);
                while ((len = in.read(buf)) > 0) {
                    fout.write(buf, 0, len);
                }
                fout.flush();
                fout.close();
                continue;
            }
            new File(dest).mkdirs();
        }
        zf.close();
    }

    private static void createDirsForZipIfNedeed(String dest, String fileName) {
        String[] dirs = fileName.split("/");
        StringBuffer buffer = new StringBuffer(dest);
        buffer.append(File.separator);
        if (dirs.length > 1) {
            for (int i = 0; i < dirs.length - 1; ++i) {
                buffer.append(dirs[i]);
                File file = new File(buffer.toString());
                if (!file.exists()) {
                    file.mkdir();
                } else if (!file.isDirectory()) {
                    file.mkdir();
                }
                buffer.append(File.separator);
            }
        } else {
            System.out.println("length = 0 or 1");
        }
    }
}

