/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import ro.atreides.utils.EventGenerator;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.LanguageProvider;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.ConfigEntry;
import ro.atreides.utils.config.ConfigGroup;
import ro.atreides.utils.config.GroupEntry;
import ro.atreides.utils.config.db.ConfigDao;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.licensing.LicenseManager;
import ro.atreides.utils.multilanguage.db.MultilangDao;

public class Config
extends EventGenerator {
    private static Config instance;
    private LanguageProvider languageProvider;
    private ConnectionPool pool;
    private boolean isManager = false;
    private Properties localProperties;
    public static final String CONFIG_PANEL__ALL = "all";
    public static final String CONFIG_PANEL__ALTELE = "altele";
    public static final String CONFIG_PANEL__CLIENTI = "clienti";
    public static final String CONFIG_PANEL__CLINICA = "clinica";
    public static final String CONFIG_PANEL__CONNECTORS = "connectors";
    public static final String CONFIG_PANEL__CONTA = "conta";
    public static final String CONFIG_PANEL__DELETE = "delete";
    public static final String CONFIG_PANEL__DEPRECATED = "deprecated";
    public static final String CONFIG_PANEL__FACTURARE = "facturare";
    public static final String CONFIG_PANEL__FINANCIAR = "financiar";
    public static final String CONFIG_PANEL__FISA_STOC = "fisastoc";
    public static final String CONFIG_PANEL__FOOD = "food";
    public static final String CONFIG_PANEL__HOTEL = "hotel";
    public static final String CONFIG_PANEL__LIVRARI = "livrari";
    public static final String CONFIG_PANEL__MENIUPDA = "meniupda";
    public static final String CONFIG_PANEL__PRINT = "print";
    public static final String CONFIG_PANEL__SHOP = "shop";
    public static final String CONFIG_PANEL__SISTEM = "sistem";
    public static final String CONFIG_PANEL__SOCIETATE = "societate";
    public static final String CONFIG_PANEL__STOCURI = "stocuri";
    public static final String CONFIG_PANEL__AUTO = "auto";
    public static final String CONFIG_PANEL__WELNESS = "wellness";

    private Config() {
        try {
            this.localProperties = new Properties();
            File f = new File(FileUtils.getCurrentDir() + File.separator + "conf" + File.separator + "local.properties");
            if (!f.exists()) {
                FileUtils.writeTextToFile(f.getAbsolutePath(), "\n");
            }
            FileInputStream fis = new FileInputStream(f);
            this.localProperties.load(fis);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            Utils.systemExit();
        }
        this.pool = ConnectionPool.getInstance();
    }

    public LanguageProvider getLanguageProvider() {
        return this.languageProvider;
    }

    public void setLanguageProvider(LanguageProvider languageProvider) {
        this.languageProvider = languageProvider;
    }

    public static synchronized Config getInstance() {
        if (instance == null) {
            instance = new Config();
        }
        return instance;
    }

    private synchronized ConfigDao getConfigDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        ConfigDao dao = null;
        while (dao == null) {
            dao = (ConfigDao)this.pool.getDao(ConfigDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(ConfigDao.class.getName(), connection);
        }
        return dao;
    }

    private synchronized MultilangDao getMultilangDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        MultilangDao dao = null;
        while (dao == null) {
            dao = (MultilangDao)this.pool.getDao(MultilangDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(MultilangDao.class.getName(), connection);
        }
        return dao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigEntry get(int idKey, int idLanguage) {
        try {
            ConfigEntry result;
            ConfigEntry configEntry = result = this.getConfigDao().get(idKey, idLanguage);
            return configEntry;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            ConfigEntry configEntry = null;
            return configEntry;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public boolean getBooleanNoCommit(String key) throws SQLException {
        String s1 = this.localProperties.getProperty(key);
        if (s1 != null) {
            Logger.logInfo(this, "Using local property : " + key + " value : " + s1);
            if (!Validators.correctBoolean(s1)) {
                Logger.logWarning(this, "Local property NOT A BOOLEAN !! : " + key + " value : " + s1);
                Utils.systemExit();
            }
            if (s1.equalsIgnoreCase("true") || s1.equals("1")) {
                return true;
            }
            if (s1.equalsIgnoreCase("false") || s1.equals("0")) {
                return false;
            }
        }
        boolean result = this.getConfigDao().getBoolean(key);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String key) {
        boolean result = false;
        try {
            result = this.getBooleanNoCommit(key);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getStringNoCommit(String key) throws SQLException {
        return this.getStringNoCommit(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String key, String defaultValue) {
        try {
            String string = this.getStringNoCommit(key, defaultValue);
            return string;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            String string = "";
            return string;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public String getStringNoCommit(String key, String defaultValue) throws SQLException {
        String s1 = this.localProperties.getProperty(key);
        if (s1 != null) {
            Logger.logInfo(this, "Using local property : " + key + " value : " + s1);
            return s1;
        }
        String result = this.getConfigDao().getString(key);
        if (result == null && defaultValue != null) {
            result = defaultValue;
        }
        if (result == null) {
            Logger.logWarning(this, "WARN: Nu am gasit configurarea \"" + key + "\"");
        }
        return result;
    }

    public int getInt(String key, int defaultValue) {
        int r = this.getInt(key);
        if (r < 0) {
            r = defaultValue;
        }
        return r;
    }

    public int getIntNoCommit(String key, int defaultValue) throws SQLException {
        int r = this.getIntNoCommit(key);
        if (r < 0) {
            r = defaultValue;
        }
        return r;
    }

    public int getIntNoCommit(String key) throws SQLException {
        String s1 = this.localProperties.getProperty(key);
        if (s1 != null) {
            Logger.logInfo(this, "Using local property : " + key + " value : " + s1);
            if (!Validators.correctInteger(s1)) {
                Logger.logWarning(this, "Local property NOT AN INTEGER !! : " + key + " value : " + s1);
                Utils.systemExit();
            }
            return Integer.parseInt(s1);
        }
        int result = this.getConfigDao().getInt(key);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(String key) {
        try {
            int result;
            int n = result = this.getIntNoCommit(key);
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            int n = -1;
            return n;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public double getDoubleNoCommit(String key) throws SQLException {
        String s1 = this.localProperties.getProperty(key);
        if (s1 != null) {
            Logger.logInfo(this, "Using local property : " + key + " value : " + s1);
            if (!Validators.correctDouble(s1)) {
                Logger.logWarning(this, "Local property NOT A Double !! : " + key + " value : " + s1);
                Utils.systemExit();
            }
            return Utils.parseDouble(s1);
        }
        double result = this.getConfigDao().getDouble(key);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(String key) {
        try {
            double result;
            double d = result = this.getDoubleNoCommit(key);
            return d;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            double d = -1.0;
            return d;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getGuiEditableConfigs(Vector ids, boolean ignoreGroups) {
        try {
            String insql = Utils.getSqlInSequence(ids);
            Vector configs = this.getConfigDao().getAllGuiEditable(this.languageProvider.getCurrentUserLanguage(), insql, ignoreGroups);
            Collections.sort(configs, new Comparator(){

                public int compare(Object o1, Object o2) {
                    ConfigEntry c1 = (ConfigEntry)o1;
                    ConfigEntry c2 = (ConfigEntry)o2;
                    return c1.getLabel().compareToIgnoreCase(c2.getLabel());
                }
            });
            Vector vector = configs;
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void newValues(Collection col) {
        try {
            for (ConfigEntry element : col) {
                this.getConfigDao().updateConfig(element.getId(), element.getValue());
            }
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
            this.notifyListeners(101);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public void setDefaultValues() {
        try {
            this.getConfigDao().resetToDefaults();
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public Vector getModules(String modulesString) {
        Vector<String> modules = new Vector<String>();
        StringTokenizer token = new StringTokenizer(modulesString, ",");
        while (token.hasMoreTokens()) {
            String module = token.nextToken();
            modules.add(module);
        }
        return modules;
    }

    public void updateValueNoCommit(String key, String value) throws SQLException {
        this.getConfigDao().updateConfig(key, value);
    }

    public void addConfigNoCommit(String propertyName, String defaultValue, boolean visible) throws SQLException {
        int idKey = this.getMultilangDao().getIdForKey(propertyName);
        if (idKey == -1) {
            this.getMultilangDao().addKey(propertyName);
            idKey = this.pool.requestConnection().getIndentityLocal();
        }
        this.getConfigDao().addConfig(idKey, defaultValue, visible ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigCommit(String propertyName, String defaultValue, boolean visible) {
        try {
            this.addConfigNoCommit(propertyName, defaultValue, visible);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateValueAndCommit(String key, String value) {
        try {
            this.updateValueNoCommit(key, value);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOptionActive(String key, String optionRequested, boolean defaultValue) {
        boolean result = defaultValue;
        try {
            String rs = this.getStringNoCommit(key);
            if (rs != null) {
                if (rs.contains(optionRequested)) {
                    result = !rs.contains("!" + optionRequested);
                } else if (!defaultValue) {
                    result = false;
                }
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            boolean bl = defaultValue;
            return bl;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getConfigGroups() {
        try {
            Vector allGroups = this.getConfigDao().getConfigGroups();
            if (!this.isManager) {
                Vector<ConfigGroup> result = new Vector<ConfigGroup>();
                for (int i = 0; i < allGroups.size(); ++i) {
                    ConfigGroup configGroup = (ConfigGroup)allGroups.elementAt(i);
                    String name = configGroup.getLabel();
                    if (!LicenseManager.configGroups.contains(name)) continue;
                    result.add(configGroup);
                }
                Vector<ConfigGroup> i = result;
                return i;
            }
            Vector vector = allGroups;
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public boolean isManager() {
        return this.isManager;
    }

    public void setManager(boolean manager) {
        this.isManager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigGroup(String name) {
        try {
            this.getConfigDao().addConfigGroup(name);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConfigInGroup(int idConfig, int idGroup) {
        try {
            boolean bl = this.getConfigDao().isConfigInGroup(idConfig, idGroup);
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGroupsForConfig(int idConfig, Vector groups) {
        try {
            this.getConfigDao().deleteMapping(idConfig, -1);
            for (int i = 0; i < groups.size(); ++i) {
                GroupEntry groupEntry = (GroupEntry)groups.elementAt(i);
                if (!groupEntry.isSelected()) continue;
                this.getConfigDao().addMapping(idConfig, groupEntry.getIdGroup());
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroupsForConfig(int idConfig, Vector groups) {
        try {
            for (int i = 0; i < groups.size(); ++i) {
                GroupEntry groupEntry = (GroupEntry)groups.elementAt(i);
                if (!groupEntry.isSelected()) continue;
                this.getConfigDao().addMapping(idConfig, groupEntry.getIdGroup());
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroupsForConfig(int idConfig, Vector groups) {
        try {
            for (int i = 0; i < groups.size(); ++i) {
                GroupEntry groupEntry = (GroupEntry)groups.elementAt(i);
                if (!groupEntry.isSelected()) continue;
                this.getConfigDao().deleteMapping(idConfig, groupEntry.getIdGroup());
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public Vector getGroupsSelectorPanelData(int idConfig) {
        Vector<GroupEntry> result = new Vector<GroupEntry>();
        Vector data = this.getConfigGroups();
        for (int i = 0; i < data.size(); ++i) {
            ConfigGroup o = (ConfigGroup)data.elementAt(i);
            GroupEntry ge = new GroupEntry();
            ge.setIdGroup(o.getId());
            ge.setGroup(o.getLabel());
            if (Config.getInstance().isConfigInGroup(idConfig, o.getId())) {
                ge.setSelected(true);
            }
            result.add(ge);
        }
        Collections.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                GroupEntry c1 = (GroupEntry)o1;
                GroupEntry c2 = (GroupEntry)o2;
                return c1.getGroup().compareToIgnoreCase(c2.getGroup());
            }
        });
        return result;
    }

    public String getLocalProperty(String propertyName) {
        String s1 = this.localProperties.getProperty(propertyName);
        if (s1 == null) {
            Logger.logWarning(this, "local.properties : Nu am gasit proprietatea \"" + propertyName + "\"");
        }
        return s1;
    }

    public static enum GlobalConfigs {
        partnerName("Introduceti numele partenerului:"),
        clientName("Introduceti numele de client:"),
        bdId("Introduceti numele bazei de date:");

        String message;

        private GlobalConfigs(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

