/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.config.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.ConfigEntry;
import ro.atreides.utils.config.ConfigGroup;
import ro.atreides.utils.db.DaoInterface;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.sql.SqlUtils;

public class ConfigDao
implements DaoInterface {
    private Connection connection;
    private PreparedStatement update;
    private PreparedStatement selectByKeyAndLanguage;
    private PreparedStatement selectByKey;
    private PreparedStatement addConfig;
    private PreparedStatement resetToDefaults;
    private PreparedStatement selectByKeyId;
    private PreparedStatement updateByKey;
    private PreparedStatement getConfigGroups;
    private PreparedStatement addConfigGroup;
    private PreparedStatement deleteMapping;
    private PreparedStatement addMapping;
    private PreparedStatement isConfigInGroup;

    public ConfigDao(Connection connection) throws SQLException {
        this.connection = connection;
        this.buildPreparedStatements();
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.isConfigInGroup = this.connection.prepareStatement("select * from mapping_Config_groups where id_config = ? and id_group = ?");
        this.addMapping = this.connection.prepareStatement("insert into mapping_config_groups (id_config,id_group) values (?,?)");
        this.deleteMapping = this.connection.prepareStatement("delete from mapping_config_groups where id_config = ? and (id_Group = ? or ? = -1)");
        this.addConfigGroup = this.connection.prepareStatement("insert into config_groups ( name ) values ( ? )");
        this.getConfigGroups = this.connection.prepareStatement("select * from config_groups order by name");
        this.selectByKeyAndLanguage = this.connection.prepareStatement("select configs.id as idConfig, messages.label as messageText, value, visibility from configs inner join keys on configs.id_key = keys.id inner join messages on keys.id = messages.id_key where keys.id = ? and messages.id_lang = ?");
        this.selectByKey = this.connection.prepareStatement("select value from configs inner join keys on configs.id_key = keys.id where keys.label = ?");
        this.addConfig = this.connection.prepareStatement("insert into configs (id_key, value, default_value, visibility) values ( ?, ?, ?, ?)");
        this.update = this.connection.prepareStatement("update configs set value = ? where id = ?");
        this.updateByKey = this.connection.prepareStatement("update configs set value = ? where id_key = ( select id from keys where label = ? )");
        this.resetToDefaults = this.connection.prepareStatement("update configs set value = default_value where visibility = 1");
        this.selectByKeyId = this.connection.prepareStatement("select * from configs where id_key = ?");
    }

    public boolean isConfigInGroup(int idConfig, int idGroup) throws SQLException {
        boolean result = false;
        this.isConfigInGroup.setInt(1, idConfig);
        this.isConfigInGroup.setInt(2, idGroup);
        ResultSet rs = this.isConfigInGroup.executeQuery();
        if (rs.next()) {
            result = true;
        }
        rs.close();
        return result;
    }

    public void addMapping(int idConfig, int idGroup) throws SQLException {
        this.addMapping.setInt(1, idConfig);
        this.addMapping.setInt(2, idGroup);
        this.addMapping.execute();
    }

    public void deleteMapping(int idConfig, int idGroup) throws SQLException {
        this.deleteMapping.setInt(1, idConfig);
        this.deleteMapping.setInt(2, idGroup);
        this.deleteMapping.setInt(3, idGroup);
        this.deleteMapping.execute();
    }

    public void addConfigGroup(String name) throws SQLException {
        this.addConfigGroup.setString(1, name);
        this.addConfigGroup.execute();
    }

    public Vector getConfigGroups() throws SQLException {
        Vector<ConfigGroup> result = new Vector<ConfigGroup>();
        ResultSet rs = this.getConfigGroups.executeQuery();
        while (rs.next()) {
            ConfigGroup cg = new ConfigGroup();
            cg.setId(rs.getInt("id"));
            cg.setLabel(rs.getString("name"));
            result.add(cg);
        }
        rs.close();
        return result;
    }

    public Vector getAllGuiEditable(int idLanguage, String inSql, boolean ignoreGroups) throws SQLException {
        Vector<ConfigEntry> result = new Vector<ConfigEntry>();
        String s = "select keys.label as name, configs.id as idConfig, configs.visibility as visibility, configs.value as value from configs inner join keys on configs.id_key = keys.id";
        if (!ignoreGroups) {
            s = s + " inner join mapping_config_groups on configs.id = mapping_config_groups.id_config";
        }
        s = s + " where configs.visibility = 1";
        if (!ignoreGroups) {
            s = s + " and mapping_config_groups.id_group in " + inSql;
        }
        ResultSet rs = SqlUtils.executeQuery(s, this.connection);
        while (rs.next()) {
            ConfigEntry ce = new ConfigEntry(rs.getInt("idConfig"), rs.getString("name"), rs.getString("value"), rs.getInt("visibility") == 1);
            result.add(ce);
        }
        rs.close();
        return result;
    }

    public ConfigEntry get(int idKey, int idLanguage) throws SQLException {
        ConfigEntry result = null;
        this.selectByKeyAndLanguage.setInt(1, idKey);
        this.selectByKeyAndLanguage.setInt(2, idLanguage);
        ResultSet rs = this.selectByKeyAndLanguage.executeQuery();
        if (rs.next()) {
            result = new ConfigEntry(rs.getInt("idConfig"), rs.getString("messageText"), rs.getString("value"), rs.getInt("visibility") == 1);
        }
        rs.close();
        return result;
    }

    public String getString(String key) throws SQLException {
        String result = null;
        this.selectByKey.setString(1, key);
        ResultSet rs = this.selectByKey.executeQuery();
        if (rs.next()) {
            result = rs.getString("value");
        }
        rs.close();
        return result;
    }

    public boolean getBoolean(String key) throws SQLException {
        return this.getInt(key) == 1;
    }

    public int getInt(String key) throws SQLException {
        String s = this.getString(key);
        if (!Validators.correctInteger(s)) {
            return -1;
        }
        return Integer.parseInt(s);
    }

    public double getDouble(String key) throws SQLException {
        double result = -1.0;
        String s = this.getString(key);
        if (Validators.correctDouble(s)) {
            result = Utils.parseDouble(s);
        }
        String mess = "Value for key : " + key + " is : as string " + s + " as double : " + result;
        Logger.logDebug(this, mess);
        System.out.println(mess);
        return result;
    }

    public void addConfig(int idKey, String defaultValue, int visibility) throws SQLException {
        this.addConfig.setInt(1, idKey);
        this.addConfig.setString(2, defaultValue);
        this.addConfig.setString(3, defaultValue);
        this.addConfig.setInt(4, visibility);
        this.addConfig.execute();
    }

    public void updateConfig(int idConfig, String newValue) throws SQLException {
        this.update.setString(1, newValue);
        this.update.setInt(2, idConfig);
        this.update.execute();
    }

    public void updateConfig(String key, String newValue) throws SQLException {
        this.updateByKey.setString(1, newValue);
        this.updateByKey.setString(2, key);
        this.updateByKey.execute();
    }

    public void resetToDefaults() throws SQLException {
        this.resetToDefaults.execute();
    }

    public int getIdConfigByKeyId(int idKey) throws SQLException {
        int result = -1;
        this.selectByKeyId.setInt(1, idKey);
        ResultSet rs = this.selectByKeyId.executeQuery();
        if (rs.next()) {
            result = rs.getInt("id");
        }
        rs.close();
        return result;
    }
}

