/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.config.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.config.ConfigEntry;
import ro.atreides.utils.config.ConfigGroup;
import ro.atreides.utils.config.ConfigReportCellRenderer;
import ro.atreides.utils.config.gui.GroupsSelectorPanel;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.DateSelectorInterface;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.MultiboxList;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.licensing.LicenseManager;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class ConfigReport
extends AbstractReportPanel {
    private Config config;
    private static String[] columns = new String[]{"Nume", LangRoAll.valoare};
    private JButton saveButton;
    private JButton cancelButton;
    private JButton reloadLicence;
    private JButton migrateLicence;
    private JButton extendLicence;
    private JButton newLicence;
    private JButton stergeSelectia;
    private JButton invertSelection;
    private MultiboxList grupuriCombo;
    private Hashtable printCriteria = new Hashtable();
    private Vector selectedConfigs = new Vector();
    private ConfigReportCellRenderer cellRenderer;
    public static final String CLIENTI_GROUPS_KEY = "Grupuri";

    public ConfigReport() {
        this.config = Config.getInstance();
    }

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable result = new Hashtable();
        Vector<Integer> groupIds = new Vector<Integer>();
        String groupNames = "";
        Vector items = this.grupuriCombo.getSelectedItems();
        for (int i = 0; i < items.size(); ++i) {
            ConfigGroup pg = (ConfigGroup)items.elementAt(i);
            groupIds.add(pg.getId());
            groupNames = groupNames + pg.getLabel();
            if (i >= items.size() - 1) continue;
            groupNames = groupNames + ",";
        }
        result.put(CLIENTI_GROUPS_KEY, groupIds);
        this.printCriteria.put(CLIENTI_GROUPS_KEY, groupNames);
        return result;
    }

    @Override
    public void printReport() {
        DialogUtils.errorDialog(GuiUtils.currentFrame, "Functie indisponibila. Incercat Excel", LangRoAll.nuPotContinua);
    }

    @Override
    public void printPreview() {
        DialogUtils.errorDialog(GuiUtils.currentFrame, "Functie indisponibila. Incercat Excel", LangRoAll.nuPotContinua);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        this.selectedConfigs.clear();
        Vector ids = (Vector)criteria.get(CLIENTI_GROUPS_KEY);
        if (ids.size() > 0) {
            return this.config.getGuiEditableConfigs(ids, false);
        }
        if (this.config.isManager()) {
            return this.config.getGuiEditableConfigs(ids, true);
        }
        return new Vector();
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    ConfigEntry entry = (ConfigEntry)o;
                    try {
                        sheet.addCell((WritableCell)new Number(0, row, (double)row));
                        Label label = new Label(1, row, entry.getLabel());
                        sheet.addCell((WritableCell)label);
                        label = new Label(2, row, entry.getValue());
                        sheet.addCell((WritableCell)label);
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return ConfigReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public DateSelectorInterface getDateSelector() {
        return null;
    }

    @Override
    public String getName() {
        return "Configurari";
    }

    @Override
    public AbstractTM buildTableModel() {
        return new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                ConfigEntry ce = (ConfigEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return ce.getLabel();
                    }
                    case 1: {
                        return ce.getValue();
                    }
                }
                return "";
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return false;
                    }
                    case 1: {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                ConfigEntry ce = (ConfigEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        String toSet = (String)aValue;
                        ce.setValue(toSet);
                    }
                }
            }
        });
    }

    @Override
    public JPanel buildTotalPanel() {
        final ConfigReport parent = this;
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        this.saveButton = new JButton(LangRoAll.salveaza);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigReport.this.config.newValues(ConfigReport.this.data);
                ConfigReport.this.raport();
            }
        });
        result.add((Component)this.saveButton, c);
        ++c.gridx;
        this.cancelButton = new JButton(LangRoAll.renunta);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigReport.this.raport();
            }
        });
        result.add((Component)this.cancelButton, c);
        ++c.gridx;
        this.cancelButton = new JButton("Valori implicite");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogUtils.confirmDialog(parent, "Aceasta operatie modifica setarile si poate impacta negativ modul de lucru. Sunteti sigur", "ATENTIE")) {
                    ConfigReport.this.config.setDefaultValues();
                    ConfigReport.this.raport();
                }
            }
        });
        ++c.gridx;
        this.reloadLicence = new JButton("Incarca licenta");
        this.reloadLicence.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LicenseManager.getInstance().loadNewLicenseAttempt(false, false, false);
            }
        });
        result.add((Component)this.reloadLicence, c);
        ++c.gridx;
        this.migrateLicence = new JButton("Cere licenta JSON");
        this.migrateLicence.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LicenseManager.getInstance().requestFromMemshare(true, false);
            }
        });
        result.add((Component)this.migrateLicence, c);
        ++c.gridx;
        this.extendLicence = new JButton("Cere extindere licenta JSON");
        this.extendLicence.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LicenseManager.getInstance().requestFromMemshare(true, true);
            }
        });
        result.add((Component)this.extendLicence, c);
        ++c.gridx;
        this.newLicence = new JButton("Cere licenta JSON noua");
        this.newLicence.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LicenseManager.getInstance().requestNewLicense(false);
            }
        });
        result.add((Component)this.newLicence, c);
        if (Config.getInstance().isManager()) {
            ++c.gridx;
            JButton addGroup = new JButton("Adauga grup configurari");
            addGroup.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    String nume = DialogUtils.inputDialog(parent, "", LangRoAll.grup);
                    ConfigReport.this.config.addConfigGroup(nume);
                }
            });
            result.add((Component)addGroup, c);
            ++c.gridy;
            c.gridx = 0;
            this.invertSelection = new JButton("Inverseaza selectia");
            this.invertSelection.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    for (int i = 0; i < ConfigReport.this.data.size(); ++i) {
                        ConfigEntry pve = (ConfigEntry)ConfigReport.this.data.elementAt(i);
                        if (pve.isSelected()) {
                            pve.setSelected(false);
                            ConfigReport.this.selectedConfigs.remove(pve);
                            continue;
                        }
                        ConfigReport.this.selectedConfigs.add(pve);
                        pve.setSelected(true);
                    }
                    ConfigReport.this.tm.fireTableDataChanged();
                }
            });
            result.add((Component)this.invertSelection, c);
            ++c.gridx;
            this.stergeSelectia = new JButton("Sterge selectia");
            this.stergeSelectia.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    ConfigReport.this.clearSelection();
                }
            });
            result.add((Component)this.stergeSelectia, c);
            ++c.gridx;
            JButton adaugaConfigurariLaGrup = new JButton("Adauga selectate in grup");
            adaugaConfigurariLaGrup.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    String title = "Adauga selectate in grup";
                    GroupsSelectorPanel gsp = new GroupsSelectorPanel(-1);
                    JDialog dia = DialogUtils.getJDialog(gsp, GuiUtils.currentFrame, "Adauga selectate in grup", 2.0);
                    gsp.setParent(dia);
                    dia.setVisible(true);
                    if (gsp.isSaved()) {
                        for (int i = 0; i < ConfigReport.this.selectedConfigs.size(); ++i) {
                            ConfigEntry integer = (ConfigEntry)ConfigReport.this.selectedConfigs.elementAt(i);
                            ConfigReport.this.config.addGroupsForConfig(integer.getId(), gsp.getData());
                        }
                        ConfigReport.this.raport();
                    }
                }
            });
            result.add((Component)adaugaConfigurariLaGrup, c);
            ++c.gridx;
            JButton stergeConfigurariLaGrup = new JButton("Sterge selectate din grup");
            stergeConfigurariLaGrup.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    String title = "Sterge selectate din grup";
                    GroupsSelectorPanel gsp = new GroupsSelectorPanel(-1);
                    JDialog dia = DialogUtils.getJDialog(gsp, GuiUtils.currentFrame, "Sterge selectate din grup", 2.0);
                    gsp.setParent(dia);
                    dia.setVisible(true);
                    if (gsp.isSaved()) {
                        for (int i = 0; i < ConfigReport.this.selectedConfigs.size(); ++i) {
                            ConfigEntry integer = (ConfigEntry)ConfigReport.this.selectedConfigs.elementAt(i);
                            ConfigReport.this.config.removeGroupsForConfig(integer.getId(), gsp.getData());
                        }
                        ConfigReport.this.raport();
                    }
                }
            });
            result.add((Component)stergeConfigurariLaGrup, c);
            ++c.gridx;
            JButton setConfigurariLaGrup = new JButton("Seteaza grup selectate");
            setConfigurariLaGrup.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    String title = "Seteaza grup selectate";
                    GroupsSelectorPanel gsp = new GroupsSelectorPanel(-1);
                    JDialog dia = DialogUtils.getJDialog(gsp, GuiUtils.currentFrame, "Seteaza grup selectate", 2.0);
                    gsp.setParent(dia);
                    dia.setVisible(true);
                    if (gsp.isSaved()) {
                        for (int i = 0; i < ConfigReport.this.selectedConfigs.size(); ++i) {
                            ConfigEntry integer = (ConfigEntry)ConfigReport.this.selectedConfigs.elementAt(i);
                            ConfigReport.this.config.updateGroupsForConfig(integer.getId(), gsp.getData());
                        }
                        ConfigReport.this.raport();
                    }
                }
            });
            result.add((Component)setConfigurariLaGrup, c);
        }
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.grup), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.grupuriCombo = new MultiboxList(new Vector(), 10);
        this.refreshGroupsFilter();
        result.add((Component)this.grupuriCombo, c);
        return result;
    }

    @Override
    public void refreshTotalPanel() {
    }

    @Override
    public void doStuff() {
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        if (this.config.isManager()) {
            this.cellRenderer = new ConfigReportCellRenderer(this.tm);
            this.updateJTableColumns(this.table);
            this.table.setSelectionMode(0);
        }
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final ConfigEntry sourceVe = (ConfigEntry)ConfigReport.this.tm.getObjectAt(selRow);
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) > 0) {
                    if (!sourceVe.isSelected()) {
                        ConfigReport.this.selectedConfigs.add(sourceVe);
                    } else {
                        ConfigReport.this.selectedConfigs.remove(sourceVe);
                    }
                    sourceVe.setSelected(!sourceVe.isSelected());
                    ConfigReport.this.tm.fireTableRowsUpdated(selRow, selRow);
                } else {
                    JPopupMenu popup = new JPopupMenu();
                    String title = "Asociere grupuri";
                    JMenuItem asociereGrupuri = new JMenuItem("Asociere grupuri");
                    popup.add(asociereGrupuri);
                    asociereGrupuri.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            GroupsSelectorPanel gsp = new GroupsSelectorPanel(sourceVe.getId());
                            JDialog dia = DialogUtils.getJDialog(gsp, GuiUtils.currentFrame, "Asociere grupuri - " + sourceVe.getLabel(), 2.0);
                            gsp.setParent(dia);
                            dia.setVisible(true);
                            if (gsp.isSaved()) {
                                ConfigReport.this.config.updateGroupsForConfig(sourceVe.getId(), gsp.getData());
                                ConfigReport.this.raport();
                            }
                        }
                    });
                    popup.setInvoker(ConfigReport.this.table);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }

    private void refreshGroupsFilter() {
        Vector allItems = Config.getInstance().getConfigGroups();
        this.grupuriCombo.refresh(allItems);
        this.grupuriCombo.setSelectedItems(allItems, true);
    }

    private void updateJTableColumns(JTable unu) {
        TableColumnModel colModel = unu.getColumnModel();
        Enumeration<TableColumn> enum1 = colModel.getColumns();
        while (enum1.hasMoreElements()) {
            TableColumn column = enum1.nextElement();
            column.setCellRenderer(this.cellRenderer);
        }
    }

    private void clearSelection() {
        this.selectedConfigs.clear();
        for (int i = 0; i < this.data.size(); ++i) {
            ConfigEntry stockViewEntry = (ConfigEntry)this.data.elementAt(i);
            stockViewEntry.setSelected(false);
        }
        this.tm.fireTableDataChanged();
    }
}

