/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.config.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.config.GroupEntry;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class GroupsSelectorPanel
extends AbstractListPanel {
    private int idConfig;
    private boolean isSaved = false;
    private JDialog parent;

    public GroupsSelectorPanel(int idConfig) {
        this.idConfig = idConfig;
        this.display();
        this.doStuff();
    }

    public void setParent(JDialog parent) {
        this.parent = parent;
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                GroupEntry ce = (GroupEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return ce.getGroup();
                    }
                    case 1: {
                        return ce.isSelected();
                    }
                }
                return "";
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return false;
                    }
                    case 1: {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                GroupEntry ce = (GroupEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        Boolean toSet = (Boolean)aValue;
                        ce.setSelected(toSet);
                    }
                }
            }
        });
        return this.tm;
    }

    @Override
    public JPanel getBottomPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        JButton saveButton = new JButton(LangRoAll.salveaza);
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                GroupsSelectorPanel.this.isSaved = true;
                GroupsSelectorPanel.this.parent.dispose();
            }
        });
        result.add((Component)saveButton, c);
        ++c.gridx;
        JButton cancelButton = new JButton(LangRoAll.renunta);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                GroupsSelectorPanel.this.parent.dispose();
            }
        });
        result.add((Component)cancelButton, c);
        return result;
    }

    @Override
    public Vector buildData() {
        return Config.getInstance().getGroupsSelectorPanelData(this.idConfig);
    }

    @Override
    public String[] buildColumns() {
        return new String[]{"Grup", "Apartine acestui grup"};
    }

    @Override
    public Class[] buildTypes() {
        return new Class[]{String.class, Boolean.class};
    }

    @Override
    public void doStuff() {
        this.refreshTable();
    }

    public Vector getData() {
        return this.tm.getData();
    }

    public boolean isSaved() {
        return this.isSaved;
    }
}

