/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import ro.atreides.utils.DateUtils;

public class ConnectionWrapper {
    private Connection connection;
    private PreparedStatement getIdentity;
    private Timestamp lastUsed;

    public ConnectionWrapper(Connection connection) throws SQLException {
        this.connection = connection;
        this.getIdentity = connection.prepareStatement("select LASTVAL()");
        this.lastUsed = DateUtils.getCurrentTimestamp();
    }

    public Timestamp getLastUsed() {
        return this.lastUsed;
    }

    public void setLastUsed(Timestamp lastUsed) {
        this.lastUsed = lastUsed;
    }

    public void commitTransaction() throws SQLException {
        this.connection.commit();
    }

    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public int getIndentityLocal() throws SQLException {
        int idColVar = -1;
        ResultSet rs = this.getIdentity.executeQuery();
        if (rs.next()) {
            idColVar = rs.getInt(1);
        }
        rs.close();
        return idColVar;
    }

    public String toString() {
        return this.connection + " used : " + this.lastUsed;
    }
}

