/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.db.DatabaseManagerInterface;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.sql.SqlUtils;
import ro.atreides.utils.tracking.TrackingLogic;

public class DatabaseManager
implements DatabaseManagerInterface {
    private static DatabaseManager instance = null;
    private String host;
    private String dbName;
    private int port;
    private Connection firstConnection;
    private boolean daemon;

    private DatabaseManager(int port, String host, String databaseName, boolean daemon) throws SQLException {
        this.port = port;
        this.host = host;
        this.dbName = databaseName;
        this.daemon = daemon;
        try {
            this.reconnect();
        }
        catch (SQLException e) {
            Logger.logException(this, new Exception("Nu am realizat conexiunea la baza de date. Va rugam verificati reteaua si incercati din nou."));
            Utils.systemExit();
        }
    }

    public void reconnect() throws SQLException {
        this.init(this.port, this.host);
        this.addComputerToNetwork(Utils.localComputerName);
    }

    public static DatabaseManager getInstance(int port, String host, String databaseName, boolean daemon) throws SQLException {
        if (instance == null) {
            instance = new DatabaseManager(port, host, databaseName, daemon);
        }
        return instance;
    }

    public static DatabaseManager getInstance() {
        return instance;
    }

    private void runPostgres(String driver, String url) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        Class.forName(driver).newInstance();
        Properties props = new Properties();
        props.put("user", "dever");
        props.put("password", "dever");
        try {
            this.firstConnection = DriverManager.getConnection(url, props);
            this.changeDBPasswordPostgres();
        }
        catch (SQLException e) {
            String message = e.getMessage();
            if (message.contains("authentication failed")) {
                props.put("password", this.getNewPassword());
                this.firstConnection = DriverManager.getConnection(url, props);
            }
            if (!this.daemon) {
                DialogUtils.errorDialog(GuiUtils.currentFrame, message, LangRoAll.eroare);
            } else {
                Logger.logError((Object)this, message);
            }
            e.printStackTrace();
            Utils.systemExit();
        }
        this.firstConnection.setAutoCommit(false);
    }

    public Connection getClientConnectionPostgres(int maxRetries) throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        String url = "jdbc:postgresql://" + this.host + ":" + this.port + "/" + this.dbName;
        System.out.println(">> Host : " + this.host + ", DB Url : " + url + " <<");
        String driver = "org.postgresql.Driver";
        Class.forName(driver).newInstance();
        Properties props = new Properties();
        props.put("user", "dever");
        props.put("password", this.getNewPassword());
        return this.getClientConnection(maxRetries, url, props);
    }

    private void runCsClientPostgres(String dbHost, int dbPort) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        String url = "jdbc:postgresql://" + dbHost + ":" + dbPort + "/" + this.dbName;
        String driver = "org.postgresql.Driver";
        this.runPostgres(driver, url);
    }

    private void changeDBPasswordPostgres() throws SQLException {
        String s1 = "alter user dever with password '" + this.getNewPassword() + "';";
        SqlUtils.executeUpdate(s1, this.firstConnection);
    }

    private String getNewPassword() {
        return "deverosimil";
    }

    private Connection getClientConnection(int maxRetries, String url, Properties props) throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        Connection connection = null;
        for (int currentTry = 1; connection == null && currentTry <= maxRetries; ++currentTry) {
            try {
                connection = DriverManager.getConnection(url, props);
                continue;
            }
            catch (SQLException e) {
                try {
                    System.out.println(">> Client Connection failed ( url = " + url + " ), retrying <<");
                    e.printStackTrace();
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
            }
        }
        if (connection != null) {
            connection.setAutoCommit(false);
        }
        return connection;
    }

    public ConnectionWrapper getConnectionWrapper(int maxTries) throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        Connection c = null;
        c = this.getClientConnectionPostgres(maxTries);
        if (c != null) {
            ConnectionWrapper result = new ConnectionWrapper(c);
            return result;
        }
        return null;
    }

    private void addComputerToNetwork(String localComputerName) throws SQLException {
        Connection conn = this.getFirstConnection();
        PreparedStatement machineExists = conn.prepareStatement("select * from network where name = ?");
        machineExists.setString(1, localComputerName);
        ResultSet rs = machineExists.executeQuery();
        if (!rs.next()) {
            PreparedStatement addMachine = conn.prepareStatement("insert into network ( name ) values ( ? )");
            addMachine.setString(1, localComputerName);
            addMachine.execute();
            conn.commit();
        }
        rs.close();
    }

    private void init(int port, String host) throws SQLException {
        try {
            this.runCsClientPostgres(host, port);
        }
        catch (InstantiationException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (IllegalAccessException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (ClassNotFoundException e) {
            Logger.logException(this, (Exception)e);
        }
        TrackingLogic.getFirstInstance(this.firstConnection);
    }

    @Override
    public Connection getFirstConnection() {
        return this.firstConnection;
    }

    public void rollBack() throws SQLException {
        this.firstConnection.rollback();
    }

    public boolean closeTransaction(boolean force) throws SQLException {
        this.firstConnection.commit();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getMajorVersion() {
        Integer result = null;
        try {
            ResultSet rs = SqlUtils.executeQuery("select max(major_version) from current_version", this.firstConnection);
            if (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
        }
        catch (SQLException e) {
        }
        finally {
            try {
                this.firstConnection.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLicenseFiles() {
        boolean result = false;
        try {
            ResultSet rs = SqlUtils.executeQuery("select id_file from file_versions where id_file in ( select id from files where filename like 'license%')", this.firstConnection);
            if (rs.next()) {
                result = true;
            }
            rs.close();
        }
        catch (SQLException e) {
        }
        finally {
            try {
                this.firstConnection.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLicensingConfigs() {
        boolean result = false;
        try {
            ResultSet rs = SqlUtils.executeQuery("select ID_KEY from configs where ID_KEY in ( select id from keys where label like 'licensing_%')", this.firstConnection);
            if (rs.next()) {
                result = true;
            }
            rs.close();
        }
        catch (SQLException e) {
        }
        finally {
            try {
                this.firstConnection.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

