/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import ro.atreides.utils.db.DaoInterface;
import ro.atreides.utils.tva.Tva;

public class TvaDao
implements DaoInterface {
    private PreparedStatement add;
    private PreparedStatement selectAll;
    private PreparedStatement delete;
    private PreparedStatement update;
    private PreparedStatement getById;
    private PreparedStatement getByCota;
    private Connection conn;

    public TvaDao(Connection conn) throws SQLException {
        this.conn = conn;
        this.buildPreparedStatements();
    }

    public Connection getConn() {
        return this.conn;
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.add = this.conn.prepareStatement("insert into tva ( cota ) values ( ?)");
        this.selectAll = this.conn.prepareStatement("select * from tva");
        this.delete = this.conn.prepareStatement("delete from tva where id = ?");
        this.update = this.conn.prepareStatement("update tva set cota = ?, casa_marcat = ? where id = ?");
        this.getById = this.conn.prepareStatement("select * from tva where id = ?");
        this.getByCota = this.conn.prepareStatement("select * from tva where cota >= ? and cota <= ?");
    }

    private Tva getTvaFromResultSet(ResultSet rs) throws SQLException {
        Tva f = new Tva(rs.getInt("id"), rs.getDouble("cota"), rs.getString("casa_marcat"));
        return f;
    }

    public Tva getByCota(double cota1, double cota2) throws SQLException {
        Tva result = null;
        this.getByCota.setDouble(1, cota1);
        this.getByCota.setDouble(2, cota2);
        ResultSet rs = this.getByCota.executeQuery();
        if (rs.next()) {
            Tva f;
            result = f = this.getTvaFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public Tva getById(int id) throws SQLException {
        Tva result = null;
        this.getById.setInt(1, id);
        ResultSet rs = this.getById.executeQuery();
        if (rs.next()) {
            Tva f;
            result = f = this.getTvaFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public void add(Tva fur) throws SQLException {
        this.add.setDouble(1, fur.getCota());
        this.add.execute();
    }

    public void delete(Tva fur) throws SQLException {
        this.delete.setInt(1, fur.getId());
        this.delete.execute();
    }

    public void update(Tva fur) throws SQLException {
        this.update.setDouble(1, fur.getCota());
        this.update.setString(2, fur.getCodCasa());
        this.update.setInt(3, fur.getId());
        this.update.execute();
    }

    public Vector<Tva> getAll() throws SQLException {
        Vector<Tva> result = new Vector<Tva>();
        ResultSet rs = this.selectAll.executeQuery();
        while (rs.next()) {
            Tva f = this.getTvaFromResultSet(rs);
            result.add(f);
        }
        rs.close();
        return result;
    }
}

