/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.dbf;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.dbf.DBFException;
import ro.atreides.utils.dbf.DBFField;
import ro.atreides.utils.dbf.DBFReader;

public class JavaDbfReaderTest {
    public static void main(String[] args) {
        try {
            FileInputStream inputStream = new FileInputStream(args[0]);
            DBFReader reader = new DBFReader(inputStream);
            int numberOfFields = reader.getFieldCount();
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < numberOfFields; ++i) {
                DBFField field = reader.getField(i);
                String detalii = field.getName() + "=" + (char)field.getDataType() + "," + field.getFieldLength() + "," + field.getDecimalCount();
                System.out.println(detalii);
                buffer.append(detalii);
                buffer.append('|');
            }
            System.out.println();
            buffer.append('\n');
            Object[] rowObjects = reader.nextRecord();
            while (rowObjects != null) {
                try {
                    for (int i = 0; i < rowObjects.length; ++i) {
                        System.out.print(rowObjects[i] + "|");
                    }
                    rowObjects = reader.nextRecord();
                }
                catch (DBFException e) {
                    e.printStackTrace();
                    System.out.println(e.getMessage());
                }
            }
            ((InputStream)inputStream).close();
            FileUtils.writeTextToFile("output.txt", buffer.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
    }
}

