/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.documente;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.db.DaoInterface;

public class DocumenteDao
implements DaoInterface {
    private Connection connection;
    private PreparedStatement addFile;
    private PreparedStatement updateFile;
    private PreparedStatement deleteFile;
    private PreparedStatement addVersionToFile;
    private PreparedStatement getFileVersion;
    private PreparedStatement getIdByFileName;

    public DocumenteDao(Connection connection) throws SQLException {
        this.connection = connection;
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.getIdByFileName = this.connection.prepareStatement("select * from files inner join file_versions on files.id=file_versions.id_file where filename = ? order by file_versions.date_add desc");
        this.addFile = this.connection.prepareStatement("insert into files(title, filename) values (?,?)");
        this.updateFile = this.connection.prepareStatement("update files set title = ?, filename = ? where id = ?");
        this.deleteFile = this.connection.prepareStatement("delete from files where id = ?");
        this.addVersionToFile = this.connection.prepareStatement("insert into file_versions(id_file, autor, comentarii, bytes, date_add) values (?, ?, ?, ?, current_timestamp)");
        this.getFileVersion = this.connection.prepareStatement("select bytes from file_versions where id_file = ? order by id desc");
    }

    public void updateFile(String newFile, String title, int id) throws SQLException {
        this.updateFile.setString(1, newFile);
        this.updateFile.setString(2, title);
        this.updateFile.setInt(3, id);
        this.updateFile.execute();
    }

    public void addFile(String title, String filename) throws SQLException {
        this.addFile.setString(1, title);
        this.addFile.setString(2, filename);
        this.addFile.execute();
    }

    public void addFileVersion(int idFile, String autor, String comentarii, InputStream stream, int fileSize) throws SQLException {
        this.addVersionToFile.setInt(1, idFile);
        this.addVersionToFile.setString(2, autor);
        this.addVersionToFile.setString(3, comentarii);
        this.addVersionToFile.setBinaryStream(4, stream, fileSize);
        this.addVersionToFile.execute();
    }

    public int getIdByFileName(String filename) throws SQLException {
        int result = -1;
        this.getIdByFileName.setString(1, filename);
        ResultSet rs = this.getIdByFileName.executeQuery();
        if (rs.next()) {
            result = rs.getInt("id");
        }
        rs.close();
        return result;
    }

    public void saveFileVersionToDisk(int idFile, File location) throws SQLException, IOException {
        InputStream result = null;
        this.getFileVersion.setInt(1, idFile);
        ResultSet rs = this.getFileVersion.executeQuery();
        if (rs.next()) {
            result = rs.getBinaryStream("bytes");
        }
        if (result != null) {
            Logger.logDebug(this, "Saving file id : " + idFile + " to location '" + location.getAbsolutePath() + "'");
            FileOutputStream of = new FileOutputStream(location);
            FileUtils.copyFiles(result, of);
        } else {
            Logger.logDebug(this, "No file version for idFile : " + idFile);
        }
        rs.close();
    }
}

