/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.documente;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import ro.atreides.utils.EventGenerator;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.MimeUtils;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.documente.DocumenteDao;

public class DocumenteLogic
extends EventGenerator {
    private static DocumenteLogic instance;
    private ConnectionPool pool = ConnectionPool.getInstance();

    private DocumenteLogic() {
    }

    private synchronized DocumenteDao getDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        DocumenteDao dao = null;
        while (dao == null) {
            dao = (DocumenteDao)this.pool.getDao(DocumenteDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(DocumenteDao.class.getName(), connection);
        }
        return dao;
    }

    public static synchronized DocumenteLogic getInstance() {
        if (instance == null) {
            instance = new DocumenteLogic();
        }
        return instance;
    }

    public int addFileNoCommit(String title, String autor, String filename, String comentarii, InputStream fin, int fileLength) throws SQLException {
        this.getDao().addFile(title, filename);
        int result = this.pool.requestConnection().getIndentityLocal();
        this.getDao().addFileVersion(result, autor, comentarii, fin, fileLength);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addFileCommit(String title, String autor, String filename, String comentarii, InputStream fin, int fileLength) {
        try {
            int result = this.addFileNoCommit(title, autor, filename, comentarii, fin, fileLength);
            this.pool.commit();
            int n = result;
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            int n = -1;
            return n;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void addFileVersionNoCommit(int idFile, String autor, String comentarii, InputStream fin, int fileLength) throws SQLException {
        this.getDao().addFileVersion(idFile, autor, comentarii, fin, fileLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileVersionCommit(int idFile, String autor, String comentarii, InputStream fin, int fileLength) {
        try {
            this.addFileVersionNoCommit(idFile, autor, comentarii, fin, fileLength);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDocument(File location, int idFile) {
        try {
            this.getDao().saveFileVersionToDisk(idFile, location);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public int getIdFileByFilenameNoCommit(String filename) throws SQLException {
        int result = this.getDao().getIdByFileName(filename);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdFileByFilenameCommit(String filename) {
        int result = -1;
        try {
            result = this.getIdFileByFilenameNoCommit(filename);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public void updateFileNoCommit(String filename, String title, int id) throws SQLException {
        this.getDao().updateFile(filename, title, id);
    }

    public int addFileShort(String title, String fileOnDisk, String fileShortName) throws SQLException, IOException {
        File f = new File(fileOnDisk);
        int size = (int)f.length();
        FileInputStream fin = new FileInputStream(fileOnDisk);
        return this.addFileNoCommit(title, "", fileShortName, "", fin, size);
    }

    public void openFile(int idFile, String shortFileName) {
        FileUtils.buildTempDir();
        File exportFile = new File(FileUtils.getTempDir() + File.separator + shortFileName);
        DocumenteLogic.getInstance().saveDocument(exportFile, idFile);
        String fullPath = exportFile.getAbsolutePath();
        MimeUtils.open(fullPath);
    }
}

