/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.events;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Shift;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.events.Event;
import ro.atreides.utils.events.db.EventsImpl;

public class EventsLogic {
    private static EventsLogic instance;
    private ConnectionPool pool = ConnectionPool.getInstance();
    public static final int APP_ID__RESTAURANT = 1;
    public static final int APP_ID__HOTEL = 2;

    private EventsLogic() {
    }

    public static synchronized EventsLogic getInstance() {
        if (instance == null) {
            instance = new EventsLogic();
        }
        return instance;
    }

    private synchronized EventsImpl getEventsImpl() {
        ConnectionWrapper connection = this.pool.requestConnection();
        EventsImpl dao = null;
        while (dao == null) {
            dao = (EventsImpl)this.pool.getDao(EventsImpl.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(EventsImpl.class.getName(), connection);
        }
        return dao;
    }

    public boolean isDayOpenNoCommit(int appId) throws SQLException {
        boolean result = this.getEventsImpl().isOpen(appId);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDayOpen(int appId) {
        try {
            boolean result;
            boolean bl = result = this.isDayOpenNoCommit(appId);
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDay(int appId) {
        try {
            this.closeDayNoCommit(appId);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void closeDayNoCommit(int appId) throws SQLException {
        if (this.isDayOpenNoCommit(appId)) {
            Event e = new Event(1, appId);
            this.getEventsImpl().add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openDay(int appId) {
        try {
            this.openDayNoCommit(appId);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void openDayNoCommit(int appId) throws SQLException {
        if (this.getEventsImpl().isClosed(appId)) {
            Event e = new Event(0, appId);
            this.getEventsImpl().add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getLastOpenDate(int appId) {
        Timestamp result = DateUtils.getStartOfDays();
        try {
            result = this.getLastOpenDateNoCommit(appId);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public Timestamp getLastOpenDateNoCommit(int appId) throws SQLException {
        Timestamp result = this.getEventsImpl().getLastOpenDate(appId);
        return result;
    }

    public Timestamp getStartForDayNoCommit(Timestamp startDay, int appId) throws SQLException {
        Timestamp result = this.getEventsImpl().getOpenDateForTimestamp(startDay, appId);
        if (result != null || (result = this.getEventsImpl().getFirstDayOpen(appId)) == null) {
            // empty if block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getStartForDay(Timestamp startDay, int appId) {
        Timestamp result = null;
        try {
            result = this.getStartForDayNoCommit(startDay, appId);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getStopForDay(Timestamp startDay, int appId) {
        Timestamp result = null;
        try {
            result = this.getEventsImpl().getCloseDateForTimestamp(startDay, appId);
            if (result == null) {
                result = new Timestamp(System.currentTimeMillis());
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Shift> getShifts(int appId) {
        try {
            Vector<Shift> vector = this.getEventsImpl().getShifts(appId);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<Shift> vector = new Vector<Shift>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }
}

