/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.events.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Shift;
import ro.atreides.utils.db.DaoInterface;
import ro.atreides.utils.events.Event;

public class EventsImpl
implements DaoInterface {
    private PreparedStatement add;
    private PreparedStatement getCloseDateForTimestamp;
    private PreparedStatement getOpenDateForTimestamp;
    private PreparedStatement getLastOpenDate;
    private PreparedStatement getLastCloseDate;
    private PreparedStatement getFirstDayOpen;
    private PreparedStatement getEvents;
    private Connection conn;

    public EventsImpl(Connection conn) throws SQLException {
        this.conn = conn;
        this.buildPreparedStatements();
    }

    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.add = this.conn.prepareStatement("insert into events ( date, type, app_id ) values ( ?, ?, ?)");
        this.getLastOpenDate = this.conn.prepareStatement("select max(date) from events where type = 0 and app_id = ?");
        this.getLastCloseDate = this.conn.prepareStatement("select max(date) from events where type = 1 and app_id = ?");
        this.getCloseDateForTimestamp = this.conn.prepareStatement("select min(date) from events where type = 1 and date > ? and app_id = ?");
        this.getOpenDateForTimestamp = this.conn.prepareStatement("select max(date) from events where type = 0 and date < ? and app_id = ?");
        this.getFirstDayOpen = this.conn.prepareStatement("select min(date) from events where type = 0 and app_id = ?");
        this.getEvents = this.conn.prepareStatement("select * from events where type = 0 and app_id = ? order by date");
    }

    public void add(Event event) throws SQLException {
        this.add.setTimestamp(1, new Timestamp(event.getDate()));
        this.add.setInt(2, event.getType());
        this.add.setInt(3, event.getAppId());
        this.add.execute();
    }

    public Timestamp getCloseDateForTimestamp(Timestamp t, int appId) throws SQLException {
        this.getCloseDateForTimestamp.setTimestamp(1, t);
        this.getCloseDateForTimestamp.setInt(2, appId);
        ResultSet rs = this.getCloseDateForTimestamp.executeQuery();
        if (rs.next()) {
            return rs.getTimestamp(1);
        }
        rs.close();
        return null;
    }

    public Timestamp getLastCloseDate(int appId) throws SQLException {
        this.getLastCloseDate.setInt(1, appId);
        ResultSet rs = this.getLastCloseDate.executeQuery();
        Timestamp result = null;
        if (rs.next()) {
            result = rs.getTimestamp(1);
        }
        rs.close();
        return result;
    }

    public Timestamp getLastOpenDate(int appId) throws SQLException {
        this.getLastOpenDate.setInt(1, appId);
        ResultSet rs = this.getLastOpenDate.executeQuery();
        Timestamp result = null;
        if (rs.next()) {
            result = rs.getTimestamp(1);
        }
        rs.close();
        return result;
    }

    public Timestamp getOpenDateForTimestamp(Timestamp t, int appId) throws SQLException {
        this.getOpenDateForTimestamp.setTimestamp(1, t);
        this.getOpenDateForTimestamp.setInt(2, appId);
        ResultSet rs = this.getOpenDateForTimestamp.executeQuery();
        Timestamp result = null;
        if (rs.next()) {
            result = rs.getTimestamp(1);
        }
        rs.close();
        return result;
    }

    public boolean isClosed(int appId) throws SQLException {
        Timestamp open = this.getLastOpenDate(appId);
        Timestamp close = this.getLastCloseDate(appId);
        if (open == null) {
            return true;
        }
        if (close == null) {
            return false;
        }
        return EventsImpl.compareTimestamps(open, close) < 0L;
    }

    public boolean isOpen(int appId) throws SQLException {
        Timestamp open = this.getLastOpenDate(appId);
        Timestamp close = this.getLastCloseDate(appId);
        if (close == null) {
            return true;
        }
        if (open == null) {
            return false;
        }
        return EventsImpl.compareTimestamps(open, close) >= 0L;
    }

    public Timestamp getFirstDayOpen(int appId) throws SQLException {
        this.getFirstDayOpen.setInt(1, appId);
        ResultSet rs = this.getFirstDayOpen.executeQuery();
        Timestamp result = null;
        if (rs.next()) {
            result = rs.getTimestamp(1);
        }
        rs.close();
        return result;
    }

    private static long compareTimestamps(Timestamp open, Timestamp close) {
        if (open == null) {
            if (close != null) {
                return -1L;
            }
            return 0L;
        }
        if (close == null) {
            if (open != null) {
                return 1L;
            }
            return 0L;
        }
        if (open.getTime() > close.getTime()) {
            return 1L;
        }
        if (open.getTime() < close.getTime()) {
            return -1L;
        }
        return 0L;
    }

    public Vector<Shift> getShifts(int appId) throws SQLException {
        Vector<Shift> result = new Vector<Shift>();
        this.getEvents.setInt(1, appId);
        ResultSet rs = this.getEvents.executeQuery();
        Timestamp start = new Timestamp(0L);
        int i = 1;
        while (rs.next()) {
            Timestamp t = rs.getTimestamp("date");
            Shift sf = new Shift();
            sf.setStart(start);
            sf.setStop(t);
            sf.setNr(i);
            start = t;
            result.add(sf);
            ++i;
        }
        rs.close();
        Shift last = new Shift();
        last.setStart(start);
        last.setNr(i);
        Timestamp stop = new Timestamp(DateUtils.advanceOneMonth(start).getTime());
        last.setStop(stop);
        result.add(last);
        return result;
    }
}

