/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import ro.atreides.utils.gui.GenericDialog;

public abstract class AbstractMultipleSelectionBox
extends JPanel {
    private JTextField fieldSelection;
    private JToggleButton buttonBox;
    protected Vector data;
    private JDialog last;
    private Vector listeners = new Vector();

    public AbstractMultipleSelectionBox(Collection data, int nrcolumns) {
        this.data = this.buildData(data);
        this.doStuff(nrcolumns);
        this.display();
    }

    protected void doStuff(int columns) {
        AbstractMultipleSelectionBox c = this;
        this.fieldSelection = new JTextField(this.toString(), columns);
        this.fieldSelection.setEditable(false);
        this.buttonBox = new JToggleButton("."){

            @Override
            protected void paintChildren(Graphics g) {
                super.paintChildren(g);
                Dimension size = this.getSize();
                double deltaX = size.width / 4;
                double deltaY = size.height / 4;
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int[] xpoints = new int[]{(int)deltaX, (int)(2.0 * deltaX), (int)(3.0 * deltaX)};
                int[] ypoints = new int[]{(int)deltaY, (int)(3.0 * deltaY), (int)deltaY};
                g2.fillPolygon(xpoints, ypoints, 3);
            }
        };
        this.buttonBox.setBorderPainted(false);
        this.buttonBox.setFocusable(false);
        final ActionListener clickAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbstractMultipleSelectionBox.this.last != null && AbstractMultipleSelectionBox.this.last.isVisible()) {
                    AbstractMultipleSelectionBox.this.hidePopup();
                    return;
                }
                AbstractMultipleSelectionBox.this.last = AbstractMultipleSelectionBox.this.getDialog();
            }
        };
        this.buttonBox.addActionListener(clickAction);
        this.fieldSelection.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                AbstractMultipleSelectionBox.this.buttonBox.setSelected(true);
                clickAction.actionPerformed(null);
            }
        });
    }

    protected void display() {
        this.setLayout(new GridBagLayout());
        this.setBorder(this.fieldSelection.getBorder());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 1;
        c.anchor = 10;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.fieldSelection, c);
        c.weightx = 0.0;
        ++c.gridx;
        this.add((Component)this.buttonBox, c);
    }

    protected abstract Component getPopupPanel();

    protected abstract Dimension getPopupSize(Component var1);

    public void refresh(Collection c) {
        Vector tmp = this.buildData(c);
        this.data.clear();
        this.data.addAll(tmp);
        this.hidePopup();
        this.refreshText();
    }

    public Vector getSelectedItems() {
        Vector<Object> vector = new Vector<Object>();
        for (ListData listData : this.data) {
            if (!listData.isSelected()) continue;
            vector.add(listData.getData());
        }
        return vector;
    }

    public void removeItem(Object item) {
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!o.equals(item)) continue;
            iterator.remove();
        }
    }

    public void removeAllItems() {
        this.data.removeAllElements();
    }

    public void addItemListener(ItemListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    public void removeListener(ItemListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public void setSelectedItem(Object item, boolean selected) {
        for (ListData listData : this.data) {
            Object data = listData.getData();
            if (data == null) {
                if (item != null) continue;
                listData.setSelected(selected);
                continue;
            }
            if (!data.equals(item)) continue;
            listData.setSelected(selected);
        }
    }

    public void setSelectedItems(Collection v, boolean selected) {
        for (Object o : v) {
            this.setSelectedItem(o, selected);
        }
    }

    public void hidePopup() {
        if (this.last != null) {
            this.last.dispose();
            this.last = null;
        }
    }

    protected Vector buildData(Collection data) {
        Vector<ListData> result = new Vector<ListData>();
        if (data != null) {
            for (Object o : data) {
                ListData ld = new ListData();
                ld.setData(o);
                result.add(ld);
            }
        }
        return result;
    }

    private JPanel getReference() {
        return this;
    }

    protected String getDelemeter() {
        return ",";
    }

    private void refreshText() {
        this.fieldSelection.setText(this.toString());
    }

    protected void notifyListeners(Object item, int state) {
        for (ItemListener l : this.listeners) {
            l.itemStateChanged(new ItemEvent(new ItemSelectable(){

                @Override
                public Object[] getSelectedObjects() {
                    return new Object[0];
                }

                @Override
                public void addItemListener(ItemListener l) {
                }

                @Override
                public void removeItemListener(ItemListener l) {
                }
            }, 0, item, state));
        }
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (ListData ld : this.data) {
            if (!ld.isSelected()) continue;
            buffer.append(ld.getData());
            buffer.append(this.getDelemeter());
        }
        return buffer.toString();
    }

    protected final JDialog getDialog() {
        Component root = SwingUtilities.getRoot(this);
        if (root instanceof Frame) {
            return new CustomDialog((Frame)root, false, (Component)this, "");
        }
        if (root instanceof Dialog) {
            return new CustomDialog((Dialog)root, false, (Component)this, "");
        }
        return null;
    }

    public class CustomDialog
    extends GenericDialog {
        private Component popupComp;

        public CustomDialog(Frame parentFrame, boolean modal, Component parent, String title) {
            super(modal, parentFrame, title);
            this.setUndecorated(true);
            this.doStuff();
            this.initialize(parent);
        }

        public CustomDialog(Dialog parentDialog, boolean modal, Component parent, String title) {
            super(modal, parentDialog, title);
            this.setUndecorated(true);
            this.doStuff();
            this.initialize(parent);
        }

        @Override
        protected void initialize(Component parent) {
            this.setResizable(false);
            this.setSize(AbstractMultipleSelectionBox.this.getPopupSize(this.popupComp));
            JPanel root = AbstractMultipleSelectionBox.this.getReference();
            Dimension size = root.getSize();
            Point p = root.getLocationOnScreen();
            this.setLocation(new Point(p.x, p.y + size.height));
            this.setVisible(true);
            this.addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    AbstractMultipleSelectionBox.this.hidePopup();
                }
            });
        }

        protected void doStuff() {
            Component popup;
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 1;
            c.anchor = 10;
            c.gridx = 0;
            c.gridy = 0;
            this.popupComp = popup = AbstractMultipleSelectionBox.this.getPopupPanel();
            this.add(popup, c);
        }

        private void disableDialog() {
            this.setVisible(false);
            this.dispose();
        }

        @Override
        public void dispose() {
            super.dispose();
            AbstractMultipleSelectionBox.this.buttonBox.setSelected(false);
        }
    }

    public class ListData {
        private Object data;
        private boolean selected = false;

        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
            AbstractMultipleSelectionBox.this.notifyListeners(this.data, this.isSelected() ? 1 : 2);
            AbstractMultipleSelectionBox.this.refreshText();
        }

        public String toString() {
            if (this.data != null) {
                return this.data.toString();
            }
            return "";
        }
    }
}

