/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import net.miginfocom.swing.MigLayout;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.gui.BarCodesPanelInterface;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class BarCodesPanel
extends JPanel {
    private int idProduct = -1;
    private JButton adauga;
    private JButton genereaza;
    private JTable table;
    private NomeclaturaLogic addBarCodeLogic = NomeclaturaLogic.getInstance();
    private ArrayList<String> originalBarcodes = new ArrayList();
    private ArrayList<String> modifiedBarcodes = new ArrayList();
    private DefaultTableModel model;
    private BarCodesPanelInterface inter;

    public BarCodesPanel() {
        this.display();
    }

    public int getIdProduct() {
        return this.idProduct;
    }

    public void setProduct(Product product) {
        if (product == null) {
            this.idProduct = -1;
            this.originalBarcodes.clear();
            this.modifiedBarcodes.clear();
        } else {
            this.idProduct = product.getId();
            Vector<String> coduri = this.addBarCodeLogic.getAllBarCodesByIdProd(this.idProduct);
            this.originalBarcodes = new ArrayList<String>(coduri);
            this.modifiedBarcodes = new ArrayList<String>(coduri);
        }
        this.model.fireTableDataChanged();
    }

    private void display() {
        this.setLayout((LayoutManager)new MigLayout("insets 2", "grow"));
        this.setBorder(new TitledBorder(LangRoAll.coduriDeBare));
        this.adauga = new JButton("Adauga cod");
        this.genereaza = new JButton("Genereaza cod");
        this.add((Component)this.adauga, "growx");
        this.add((Component)this.genereaza, "growx, wrap");
        this.model = new DefaultTableModel(){

            @Override
            public String getColumnName(int column) {
                return "Cod bare";
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public int getRowCount() {
                return BarCodesPanel.this.modifiedBarcodes.size();
            }

            @Override
            public Object getValueAt(int row, int column) {
                return BarCodesPanel.this.modifiedBarcodes.get(row);
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.table = new JTable(this.model);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add((Component)scrollPane, "span 2, grow");
        this.doStuff();
    }

    public void setInter(BarCodesPanelInterface inter) {
        this.inter = inter;
    }

    private void doStuff() {
        final BarCodesPanel parent = this;
        this.adauga.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String cod;
                String defaultCode = "";
                if (BarCodesPanel.this.inter != null) {
                    defaultCode = BarCodesPanel.this.inter.getDefaultCodBare();
                }
                if ((cod = DialogUtils.inputDialog(GuiUtils.currentFrame, defaultCode, "BarCode")) != null) {
                    Product product = BarCodesPanel.this.checkIfExistsBarcode(cod);
                    if (product == null) {
                        BarCodesPanel.this.modifiedBarcodes.add(cod);
                        BarCodesPanel.this.model.fireTableDataChanged();
                    } else {
                        DialogUtils.errorDialog(parent, LangRoAll.codBareExista + product.getName() + "(" + product.getCod() + ")", LangRoAll.eroare);
                    }
                }
            }
        });
        this.genereaza.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String cod = StockLogic.getInstance().getStockInterface().getNewBarcode();
                BarCodesPanel.this.modifiedBarcodes.add(cod);
                BarCodesPanel.this.model.fireTableDataChanged();
            }
        });
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                final int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) <= 0) {
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem delete = new JMenuItem("Sterge cod");
                    popup.add(delete);
                    delete.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            int rowCount = BarCodesPanel.this.model.getRowCount();
                            if (rowCount > 1) {
                                BarCodesPanel.this.modifiedBarcodes.remove(selRow);
                                BarCodesPanel.this.model.fireTableDataChanged();
                            } else {
                                DialogUtils.errorDialog(parent, LangRoAll.celPutinUnCod, LangRoAll.eroare);
                            }
                        }
                    });
                    popup.setInvoker(BarCodesPanel.this.table);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }

    public void clearTable() {
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        model.setRowCount(0);
    }

    public Vector<String> getModifiedBarcodes() {
        return new Vector<String>(this.modifiedBarcodes);
    }

    private Product checkIfExistsBarcode(String barCode) {
        Product result = null;
        result = NomeclaturaLogic.getInstance().getProductByCodBare(barCode);
        return result;
    }

    public void editable(boolean bool) {
        this.setEnabled(bool);
        this.adauga.setEnabled(bool);
        this.genereaza.setEnabled(bool);
        this.table.setEnabled(bool);
    }
}

