/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui;

import java.util.Collection;
import java.util.Vector;
import javax.swing.JComboBox;
import ro.atreides.utils.HtmlComboReady;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.xcombo.XComboBox;

public class ComboUtils {
    public static JComboBox buildComboWithAll(Collection elements) {
        JComboBox result = new JComboBox();
        return ComboUtils.internallyBuildCombo(result, elements, true, "All");
    }

    public static JComboBox buildCombo(Collection elements) {
        JComboBox result = new JComboBox();
        return ComboUtils.internallyBuildCombo(result, elements, false, "All");
    }

    private static JComboBox internallyBuildCombo(JComboBox combo, Collection items, boolean all, String allObject) {
        if (all) {
            combo.addItem(allObject);
        }
        for (Object o : items) {
            combo.addItem(o);
        }
        if (combo.getItemCount() > 0) {
            combo.setSelectedIndex(0);
        }
        return combo;
    }

    public static JComboBox replaceItemsForCombo(JComboBox combo, Collection newItems, boolean allItems) {
        combo.removeAllItems();
        return ComboUtils.internallyBuildCombo(combo, newItems, allItems, "All");
    }

    public static JComboBox replaceItemsForCombo(JComboBox combo, Collection newItems, boolean allItems, String allObject) {
        combo.removeAllItems();
        return ComboUtils.internallyBuildCombo(combo, newItems, allItems, allObject);
    }

    public static JComboBox replaceItemsForCombo(JComboBox combo, Collection newItems, String allObject) {
        return ComboUtils.replaceItemsForCombo(combo, newItems, true, allObject);
    }

    public static JComboBox replaceItemsForCombo(JComboBox combo, Collection newItems) {
        return ComboUtils.replaceItemsForCombo(combo, newItems, true);
    }

    public static boolean anythingButAllSelected(JComboBox combo) {
        int index = combo.getSelectedIndex();
        if (index != -1) {
            Object selected = combo.getSelectedItem();
            return !selected.equals("All");
        }
        return false;
    }

    public static boolean anythingButAllSelected(XComboBox combo) {
        int index = combo.getSelectedIndex();
        if (index != -1) {
            Object selected = combo.getSelectedItem();
            return !selected.equals("All");
        }
        if (combo.getSelectedItem() != null) {
            Object selected = combo.getSelectedItem();
            return Validators.correctString(selected.toString()) && !selected.equals("All");
        }
        return false;
    }

    public static String getStringForHtmlCombo(Vector items, Object selectedItem, String comboName, String action) {
        String result = "<select name=\"" + comboName + "\"" + (action != null ? action : "") + ">";
        for (int i = 0; i < items.size(); ++i) {
            HtmlComboReady o = (HtmlComboReady)items.elementAt(i);
            String s = "<option value=\"" + o.getId() + "\" " + (o.equals(selectedItem) ? "selected" : "") + ">" + o.toString() + "</option>";
            result = result + s + "\n";
        }
        result = result + "</select>";
        return result;
    }
}

