/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JTextField;
import mseries.Calendar.MDateSelectorConstraints;
import mseries.Calendar.MDefaultPullDownConstraints;
import mseries.ui.MDateEntryField;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class DateAndTimeChooser
extends JPanel {
    private MDateEntryField dataChooser;
    private JTextField timeChooser;

    public DateAndTimeChooser(String dataTooltip) {
        this(dataTooltip, true);
    }

    public DateAndTimeChooser(String dataTooltip, boolean showTime) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 0, 0);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 1;
        this.dataChooser = new MDateEntryField((DateFormat)Formatters.SHORT_DATE_FORMAT_RO);
        this.dataChooser.setValue(new Date());
        this.dataChooser.setEditable(true);
        MDefaultPullDownConstraints c1 = new MDefaultPullDownConstraints();
        c1.firstDay = 2;
        c1.changerStyle = 2;
        this.dataChooser.setConstraints((MDateSelectorConstraints)c1);
        this.dataChooser.setToolTipText(dataTooltip);
        this.dataChooser.setMinimum(DateUtils.getStartOfCentury());
        this.dataChooser.setShowTodayButton(true);
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.dataChooser, c);
        this.timeChooser = new JTextField();
        this.timeChooser.setText("00:00");
        if (showTime) {
            ++c.gridx;
            this.add((Component)this.timeChooser, c);
        }
    }

    public Date getDateAndTime() {
        try {
            Date d = this.dataChooser.getValue();
            return DateUtils.setTimeToDate2(d, this.timeChooser);
        }
        catch (ParseException e1) {
            DialogUtils.errorDialog(GuiUtils.currentFrame, "Va rugam completati corect data", LangRoAll.nuPotContinua);
            return null;
        }
    }

    public void today() {
        this.dataChooser.setValue(new Date());
    }

    public void setDate(Date newDate) {
        this.dataChooser.setValue(newDate);
        this.dataChooser.setText(Formatters.SHORT_DATE_FORMAT_RO.format(newDate));
    }
}

