/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public abstract class EnhancedTableModel
extends AbstractTableModel {
    private Vector _items = null;
    private int[] _viewIndexes = null;
    private int _sortedColumn = -1;
    private boolean _ascending = true;

    public EnhancedTableModel(Collection data) {
        this.updateTable(data);
    }

    private void updateTable(Collection data) {
        this._items = data == null ? new Vector() : new Vector(data);
        this.initIndexes();
        this.fireTableDataChanged();
    }

    private void initIndexes() {
        this._viewIndexes = new int[this._items.size()];
        for (int i = 0; i < this._viewIndexes.length; ++i) {
            this._viewIndexes[i] = i;
        }
    }

    @Override
    public int getRowCount() {
        return this._items.size();
    }

    protected Object getObjectAtRow(int rowIndex) {
        if (this._items == null) {
            return null;
        }
        if (rowIndex < 0 || rowIndex >= this._items.size()) {
            return null;
        }
        int line = this._viewIndexes[rowIndex];
        return this._items.elementAt(line);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public Vector getItems() {
        return this._items;
    }

    public void setItems(Collection items) {
        this.updateTable(items);
    }

    public void sortByColumn(int columnIndex) {
        if (columnIndex == this._sortedColumn) {
            this._ascending = !this._ascending;
        } else {
            this._sortedColumn = columnIndex;
            this._ascending = true;
        }
        this.calculateIndexes(columnIndex);
    }

    private void calculateIndexes(int columnIndex) {
        Vector v = (Vector)this._items.clone();
        Comparator c = this.getComparatorForColumn(columnIndex);
        Collections.sort(v, c);
        if (!this._ascending) {
            Collections.reverse(v);
        }
        int poz = 0;
        for (Object o : v) {
            this._viewIndexes[poz++] = this._items.indexOf(o);
        }
        this.fireTableDataChanged();
    }

    protected abstract Comparator getComparatorForColumn(int var1);

    public boolean isSortedByColumn(int columnIndex) {
        return this._sortedColumn == columnIndex;
    }

    public boolean isSortedAscending() {
        return this._ascending;
    }
}

