/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.MyJtextAreaWrapper;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.table.ColumnSizeProvider;

public class GuiUtils {
    public static boolean isFullScreen = false;
    public static JFrame currentFrame;
    public static String appTitle;
    public static String clientName;
    public static String currentVersion;
    public static boolean daemon;
    private static final GridBagConstraints gbc;

    public static String[] getAllFonts() {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontFamilies = env.getAvailableFontFamilyNames();
        return fontFamilies;
    }

    public static void selectAllText(JTextField text) {
        text.setSelectionStart(0);
        text.setSelectionEnd(text.getText().length());
    }

    public static void updateJTableColumnSize(JTable table, ColumnSizeProvider tm) {
        Dimension tableDim = table.getPreferredSize();
        double total = 0.0;
        for (int i = 0; i < table.getColumnModel().getColumnCount(); ++i) {
            total += (double)tm.getColumnSize(i);
        }
        double tableWidth = tableDim.width;
        double fraction = tableWidth / total;
        for (int i = 0; i < table.getColumnModel().getColumnCount(); ++i) {
            TableColumn column = table.getColumnModel().getColumn(i);
            double size = fraction * (double)tm.getColumnSize(i);
            column.setPreferredWidth((int)size);
            column.setWidth((int)size);
        }
    }

    public static void updateJTableColumns(JTable unu, DefaultTableCellRenderer cellRenderer) {
        TableColumnModel colModel = unu.getColumnModel();
        Enumeration<TableColumn> enum1 = colModel.getColumns();
        while (enum1.hasMoreElements()) {
            TableColumn column = enum1.nextElement();
            column.setCellRenderer(cellRenderer);
        }
    }

    public static Frame getFrameForComponent(Component c) {
        return (Frame)SwingUtilities.windowForComponent(c);
    }

    public static Color negateColor(Color toNegate) {
        int r = toNegate.getRed();
        int g = toNegate.getGreen();
        int b = toNegate.getBlue();
        r = 255 - r;
        g = 255 - g;
        b = 255 - b;
        return new Color(r, g, b);
    }

    public static void updateJTableRowSize(JTable t, int size) {
        t.setRowHeight(size);
    }

    public static JPanel wrapInBackgroundImage(JComponent component, Icon backgroundIcon) {
        return GuiUtils.wrapInBackgroundImage(component, backgroundIcon, 1, 10);
    }

    public static JPanel wrapInBackgroundImage(JComponent component, Icon backgroundIcon, int verticalAlignment, int horizontalAlignment) {
        component.setOpaque(false);
        JPanel backgroundPanel = new JPanel(new GridBagLayout());
        backgroundPanel.add((Component)component, gbc);
        JLabel backgroundImage = new JLabel(backgroundIcon);
        backgroundImage.setPreferredSize(new Dimension(1, 1));
        backgroundImage.setMinimumSize(new Dimension(1, 1));
        backgroundImage.setVerticalAlignment(verticalAlignment);
        backgroundImage.setHorizontalAlignment(horizontalAlignment);
        backgroundPanel.add((Component)backgroundImage, gbc);
        return backgroundPanel;
    }

    public static Color getColor(String htmlColor) {
        if (Validators.correctString(htmlColor)) {
            int color = Integer.parseInt(htmlColor, 16);
            Color c = new Color(color);
            return c;
        }
        return null;
    }

    public static JPanel getCardClientPanel(String fullCardPath, String fullClientPicturePath, int pictureX, int pictureY, int pictureDx, int pictureDy, String clientName, int nameX, int nameY, int nameDx, int nameDy, int nameFontSize, String htmlCOlor) throws MalformedURLException {
        JPanel foregroundPanel = new JPanel();
        foregroundPanel.setLayout(null);
        foregroundPanel.setOpaque(false);
        JLabel nume = new JLabel(clientName);
        nume.setFont(new Font(null, 0, nameFontSize));
        Color c = GuiUtils.getColor(htmlCOlor);
        nume.setForeground(c);
        nume.setLocation(nameX, nameY);
        nume.setSize(nameDx, nameDy);
        foregroundPanel.add(nume);
        ImageIcon clientIcon = Utils.getImageFromDiskAbsolutePath(fullClientPicturePath);
        JLabel ic = new JLabel(clientIcon);
        ic.setLocation(pictureX, pictureY);
        ic.setSize(pictureDx, pictureDy);
        foregroundPanel.add(ic);
        ImageIcon bg = Utils.getImageFromDiskAbsolutePath(fullCardPath);
        return GuiUtils.wrapInBackgroundImage(foregroundPanel, bg);
    }

    public static void setScrollSize(JScrollPane scroll, int SCROLLBAR_SIZE) {
        JScrollBar vsb = scroll.getVerticalScrollBar();
        Dimension sbsize = vsb.getSize();
        Dimension newsbsize = new Dimension(SCROLLBAR_SIZE, (int)sbsize.getHeight());
        vsb.setPreferredSize(newsbsize);
        JScrollBar hsb = scroll.getHorizontalScrollBar();
        sbsize = hsb.getSize();
        newsbsize = new Dimension((int)sbsize.getWidth(), SCROLLBAR_SIZE);
        hsb.setPreferredSize(newsbsize);
    }

    public static JPanel buildJTextAreaWithWrapper(JTextArea textArea) {
        MyJtextAreaWrapper textAreaPanel = new MyJtextAreaWrapper((LayoutManager)new MigLayout("wrap", "[grow,fill]", "[grow]"));
        textAreaPanel.add(textArea);
        return textAreaPanel;
    }

    public static boolean isXComboBox(Component aComponent) {
        String detaliiComponent = aComponent.toString();
        return detaliiComponent.contains("ComboBoxEditor") || detaliiComponent.contains("javax.swing.JTextField[ComboBox.textField");
    }

    public static boolean openLinkInBrowser(String url) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(new URI(url));
                return true;
            }
            catch (IOException | URISyntaxException e) {
                Logger.logException(GuiUtils.class.getName(), e);
            }
        } else {
            try {
                String os = System.getProperty("os.name").toLowerCase();
                if (os.contains("windows")) {
                    Runtime rt = Runtime.getRuntime();
                    rt.exec("rundll32 url.dll,FileProtocolHandler " + url);
                } else if (os.contains("mac")) {
                    Runtime rt = Runtime.getRuntime();
                    rt.exec("open" + url);
                } else if (os.contains("linux")) {
                    Runtime rt = Runtime.getRuntime();
                    String[] browsers = new String[]{"firefox", "mozilla", "epiphany", "konqueror", "netscape", "opera", "links", "lynx"};
                    StringBuffer cmd = new StringBuffer();
                    for (int i = 0; i < browsers.length; ++i) {
                        cmd.append((i == 0 ? "" : " || ") + browsers[i] + " \"" + url + "\" ");
                    }
                    rt.exec(new String[]{"sh", "-c", cmd.toString()});
                }
                return true;
            }
            catch (IOException e) {
                Logger.logException(GuiUtils.class.getName(), (Exception)e);
            }
        }
        return false;
    }

    static {
        daemon = false;
        gbc = new GridBagConstraints();
        GuiUtils.gbc.gridx = 0;
        GuiUtils.gbc.gridy = 0;
        GuiUtils.gbc.weightx = 1.0;
        GuiUtils.gbc.weighty = 1.0;
        GuiUtils.gbc.fill = 1;
        GuiUtils.gbc.anchor = 18;
    }
}

