/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.JComponent;

public class JMultilineLabel
extends JComponent {
    private String text;
    private Insets margin = new Insets(5, 5, 5, 5);
    private int maxWidth = Integer.MAX_VALUE;
    private boolean justify;
    private final FontRenderContext frc = new FontRenderContext(null, false, false);

    private void morph() {
        this.revalidate();
        this.repaint();
    }

    public void setMargin(Insets margin) {
        this.margin = margin;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        String old = this.text;
        this.text = text;
        this.firePropertyChange("text", old, this.text);
        if (old == null ? text != null : !old.equals(text)) {
            this.morph();
        }
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        if (maxWidth <= 0) {
            throw new IllegalArgumentException();
        }
        int old = this.maxWidth;
        this.maxWidth = maxWidth;
        this.firePropertyChange("maxWidth", old, this.maxWidth);
        if (old != this.maxWidth) {
            this.morph();
        }
    }

    public boolean isJustified() {
        return this.justify;
    }

    public void setJustified(boolean justify) {
        boolean old = this.justify;
        this.justify = justify;
        this.firePropertyChange("justified", old, this.justify);
        if (old != this.justify) {
            this.repaint();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.paintOrGetSize(null, this.getMaxWidth());
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintOrGetSize((Graphics2D)g, this.getWidth());
    }

    private Dimension paintOrGetSize(Graphics2D g, int width) {
        Insets insets = this.getInsets();
        double w = insets.left + insets.right + this.margin.left + this.margin.right;
        double x = insets.left + this.margin.left;
        double y = insets.top + this.margin.top;
        if ((width -= insets.left + insets.right + this.margin.left + this.margin.right) > 0 && this.text != null && this.text.length() > 0) {
            AttributedString as = new AttributedString(this.getText());
            as.addAttribute(TextAttribute.FONT, this.getFont());
            AttributedCharacterIterator aci = as.getIterator();
            LineBreakMeasurer lbm = new LineBreakMeasurer(aci, this.frc);
            double max = 0.0;
            while (lbm.getPosition() < aci.getEndIndex()) {
                TextLayout textLayout = lbm.nextLayout(width);
                if (g != null && this.isJustified() && (double)textLayout.getVisibleAdvance() > 0.8 * (double)width) {
                    textLayout = textLayout.getJustifiedLayout(width);
                }
                if (g != null) {
                    textLayout.draw(g, (float)x, (float)(y + (double)textLayout.getAscent()));
                }
                y += (double)(textLayout.getDescent() + textLayout.getLeading() + textLayout.getAscent());
                max = Math.max(max, (double)textLayout.getVisibleAdvance());
            }
            w += max;
        }
        return new Dimension((int)Math.ceil(w), (int)Math.ceil(y) + insets.bottom + this.margin.bottom);
    }
}

