/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import ro.atreides.utils.gui.AbstractMultipleSelectionBox;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;

public class MultiboxTable
extends AbstractMultipleSelectionBox {
    public MultiboxTable(Collection data, int nrcolumns) {
        super(data, nrcolumns);
    }

    @Override
    protected Component getPopupPanel() {
        AbstractListPanel table = new AbstractListPanel(){

            @Override
            public AbstractTM buildTableModel() {
                this.tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

                    @Override
                    public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                        AbstractMultipleSelectionBox.ListData ld = (AbstractMultipleSelectionBox.ListData)data.get(rowIndex);
                        if (columnIndex == 1) {
                            ld.setSelected(!ld.isSelected());
                        }
                    }

                    @Override
                    public boolean isCellEditable(int rowIndex, int columnIndex) {
                        return columnIndex == 1;
                    }

                    @Override
                    public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                        AbstractMultipleSelectionBox.ListData o = (AbstractMultipleSelectionBox.ListData)data.elementAt(rowIndex);
                        switch (columnIndex) {
                            case 0: {
                                return o.toString();
                            }
                            case 1: {
                                return new Boolean(o.isSelected());
                            }
                        }
                        return null;
                    }
                });
                return this.tm;
            }

            @Override
            public JPanel getBottomPanel() {
                return null;
            }

            @Override
            public Vector buildData() {
                return MultiboxTable.this.data;
            }

            @Override
            public String[] buildColumns() {
                return new String[]{"Name", "selected"};
            }

            @Override
            public Class[] buildTypes() {
                return new Class[]{String.class, Boolean.class};
            }

            @Override
            public void doStuff() {
                this.display();
            }
        };
        table.doStuff();
        table.setBorder(new LineBorder(Color.BLACK));
        return table;
    }

    @Override
    protected Dimension getPopupSize(Component popupComp) {
        return ((AbstractListPanel)popupComp).getJTable().getPreferredScrollableViewportSize();
    }
}

