/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import mseries.Calendar.MDateSelectorConstraints;
import mseries.Calendar.MDefaultPullDownConstraints;
import mseries.ui.MDateEntryField;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.gui.DateSelectorInterface;
import ro.atreides.utils.gui.dialogs.DialogUtils;

public class SimpleDateSelector
extends JPanel
implements DateSelectorInterface {
    private JLabel dayLabel;
    private JLabel timeLabel;
    private MDateEntryField dayTextField;
    private JTextField timeField;

    public SimpleDateSelector() {
        this.display(true);
    }

    public SimpleDateSelector(boolean withTime) {
        this.display(withTime);
    }

    @Override
    public void selectDay() {
    }

    @Override
    public void selectPeriod() {
    }

    @Override
    public void setStartDate(Date start) {
        this.setStopDate(start);
    }

    @Override
    public void setStopDate(Date stop) {
        this.dayTextField.setValue(stop);
        String time = DateUtils.getTimeFromDate(stop);
        this.timeField.setText(time);
    }

    private JPanel initStartStopPanel(boolean withTime) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        this.dayLabel = new JLabel("Data: ");
        panel.add((Component)this.dayLabel, c);
        c.weightx = 1.0;
        ++c.gridx;
        c.fill = 2;
        this.dayTextField = new MDateEntryField((DateFormat)Formatters.SHORT_DATE_FORMAT_RO);
        this.dayTextField.setValue(new Date());
        this.dayTextField.setEditable(true);
        MDefaultPullDownConstraints c1 = new MDefaultPullDownConstraints();
        c1.firstDay = 2;
        c1.changerStyle = 2;
        this.dayTextField.setConstraints((MDateSelectorConstraints)c1);
        this.dayTextField.setToolTipText("Alege data");
        this.dayTextField.setMinimum(DateUtils.getStartOfCentury());
        this.dayTextField.setShowTodayButton(true);
        panel.add((Component)this.dayTextField, c);
        c.weightx = 0.0;
        this.timeLabel = new JLabel("Ora: ");
        this.timeField = new JTextField(5);
        this.timeField.setText("00:00");
        if (withTime) {
            ++c.gridx;
            panel.add((Component)this.timeLabel, c);
            ++c.gridx;
            panel.add((Component)this.timeField, c);
        }
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 4;
        JLabel sizeSetter = new JLabel("____________________________________");
        panel.add((Component)sizeSetter, c);
        return panel;
    }

    private void display(boolean withTime) {
        JPanel timePanel = this.initStartStopPanel(withTime);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(5, 5, 5, 0);
        this.add((Component)timePanel, c);
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public Date[] getDates() {
        Date[] result = new Date[2];
        try {
            Date date = this.dayTextField.getValue();
            String startTime = this.timeField.getText();
            int hours = 0;
            int minutes = 0;
            try {
                StringTokenizer t = new StringTokenizer(startTime, ":");
                hours = Integer.parseInt(t.nextToken());
                minutes = Integer.parseInt(t.nextToken());
            }
            catch (NumberFormatException e) {
                DialogUtils.errorDialog(this, "Timp incorect : " + startTime, "Utilizez 00:00");
                hours = 0;
                minutes = 0;
            }
            catch (NoSuchElementException e) {
                DialogUtils.errorDialog(this, "Timp incorect : " + startTime, "Utilizez 00:00");
                hours = 0;
                minutes = 0;
            }
            int seconds = 0;
            int millis = 0;
            result[0] = date = DateUtils.setTimeToDate(date, hours, minutes, seconds, millis);
            result[1] = date;
        }
        catch (ParseException e) {
            Logger.logException(this, (Exception)e);
        }
        return result;
    }
}

