/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui;

import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.swing.JTextField;
import ro.atreides.utils.Utils;

public class Validators {
    public static boolean correctFloatTextField(JTextField text) {
        if (Validators.correctDouble(text.getText())) {
            return true;
        }
        text.selectAll();
        text.requestFocus();
        return false;
    }

    public static boolean correctCodBare(String toCheck) {
        if (toCheck == null || toCheck.trim().equals("")) {
            return false;
        }
        try {
            new BigInteger(toCheck);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean correctString(String toCheck) {
        return toCheck != null && !toCheck.trim().equals("");
    }

    public static boolean correctBoolean(String toCheck) {
        if (Validators.correctString(toCheck)) {
            return toCheck.equals("true") || toCheck.equals("false") || toCheck.equals("1") || toCheck.equals("0");
        }
        return false;
    }

    public static boolean correctDate(String toCheck, SimpleDateFormat format) {
        if (Validators.correctString(toCheck)) {
            try {
                format.parse(toCheck);
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean correctDouble(String toCheck) {
        if (Validators.correctString(toCheck)) {
            try {
                Utils.parseDouble(toCheck);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean correctInteger(String toCheck) {
        if (Validators.correctString(toCheck)) {
            try {
                Utils.parseInt(toCheck);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean correctBigInteger(String toCheck) {
        if (Validators.correctString(toCheck)) {
            try {
                BigInteger f = new BigInteger(toCheck);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean correctOnlyDigits(String toCheck) {
        return Validators.correctString(toCheck) && toCheck.matches("[0-9]+") && toCheck.length() > 2;
    }
}

