/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JLabel;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;

public class CardInputDialog
extends JDialog {
    private String codAutentificare = "";
    private static String TITLE = "Introduceti cardul";
    private static String TEXT = "Citire card";
    private String text;
    private int codLength;

    public CardInputDialog(Frame parent, boolean modal, int codLength) {
        this(parent, modal, codLength, TITLE, TEXT);
    }

    public CardInputDialog(Frame parent, boolean modal, int codLength, String title, String text) {
        super(parent, title, modal);
        this.text = text;
        this.codLength = codLength;
        this.display();
        this.pack();
        int width = this.getWidth();
        int height = this.getHeight();
        int x = 0;
        int y = 0;
        if (parent != null) {
            int parentWidth = parent.getWidth();
            int parentHeight = parent.getHeight();
            x = parent.getX() + (parentWidth - width) / 2;
            y = parent.getY() + (parentHeight - height) / 2;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        this.setBounds(x, y, width, height);
    }

    private void display() {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 1.0;
        c.insets = new Insets(20, 20, 20, 20);
        c.gridy = 0;
        c.gridx = 0;
        JLabel card = new JLabel(this.text);
        card.setForeground(Color.RED);
        card.setFont(new Font(null, 1, 16));
        this.getContentPane().add((Component)card, c);
        this.getContentPane().setFocusable(true);
        String stopDelimiters = Config.getInstance().getString("cardStopDelimiters");
        final Vector delim = Utils.splitString(stopDelimiters, ',');
        this.getContentPane().addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                CardInputDialog.this.codAutentificare = CardInputDialog.this.codAutentificare + String.valueOf(c);
                Logger.logDebugVerbose(this, "Key : \"" + c + "\"");
                boolean stopDelimiter = false;
                for (int i = 0; i < delim.size() && !stopDelimiter; ++i) {
                    String s = (String)delim.elementAt(i);
                    if (c != s.charAt(0)) continue;
                    stopDelimiter = true;
                }
                if (stopDelimiter || CardInputDialog.this.codAutentificare.length() >= CardInputDialog.this.codLength) {
                    CardInputDialog.this.dispose();
                    Logger.logDebug(this, "Am citit : \"" + CardInputDialog.this.codAutentificare + "\"");
                }
            }
        });
        this.getContentPane().requestFocus();
    }

    public String getCodAutentificare() {
        return this.codAutentificare;
    }
}

