/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui.dialogs;

import java.awt.Component;
import java.io.File;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import ro.atreides.utils.Utils;

public class FileDialog {
    public static String getSaveDialogLocation(JComponent current, String title, final String extension) {
        JFileChooser chooser = new JFileChooser(".");
        chooser.setDialogTitle(title);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(extension);
            }

            @Override
            public String getDescription() {
                return extension + " files";
            }
        });
        int sel = chooser.showSaveDialog(current);
        switch (sel) {
            case 0: {
                File f = chooser.getSelectedFile();
                String dir = f.getParent();
                String name = f.getName();
                if (!name.endsWith(extension)) {
                    f = new File(dir, name + "." + extension);
                }
                String fullPath = f.getAbsolutePath();
                return fullPath;
            }
        }
        return null;
    }

    public static String getLoadDialogLocation(Component current, String title, final String extensions) {
        JFileChooser chooser = new JFileChooser(".");
        chooser.setDialogTitle(title);
        final Vector ext = Utils.splitString(extensions, ',');
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (!f.isDirectory()) {
                    String name = f.getName().toLowerCase();
                    for (int i = 0; i < ext.size(); ++i) {
                        String s = (String)ext.elementAt(i);
                        if (!name.endsWith(s = s.toLowerCase())) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public String getDescription() {
                return extensions + " files";
            }
        });
        int sel = chooser.showOpenDialog(current);
        chooser.setFileSelectionMode(0);
        switch (sel) {
            case 0: {
                String fullPath = chooser.getSelectedFile().getAbsolutePath();
                return fullPath;
            }
        }
        return null;
    }

    public static String getLoadDialogFolder(JComponent current, String title) {
        JFileChooser chooser = new JFileChooser(".");
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(title);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Folders";
            }
        });
        int sel = chooser.showOpenDialog(current);
        switch (sel) {
            case 0: {
                File selectedFile = chooser.getSelectedFile();
                String fullPath = selectedFile.getAbsolutePath();
                return fullPath;
            }
        }
        return null;
    }
}

