/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import ro.atreides.stocks.Magazie;
import ro.atreides.utils.gui.CenteredJDialog;
import ro.atreides.utils.gui.GuiUtils;

public class TransferIntreMagaziiDialog
extends CenteredJDialog {
    private final Component parent = this;
    private Vector<Magazie> magazii = new Vector();
    private Magazie sursa;
    private Magazie destinatie;
    double scale = 1.0;
    private Font font = new Font("Arial", 0, 60);
    private Font titleFont = new Font("Arial", 1, 40);
    private final Integer STANGA = 1;
    private final Integer DREAPTA = 2;

    public TransferIntreMagaziiDialog(Vector items) {
        super("Selectati sursa si destinatia");
        this.magazii = items;
        this.display();
        this.center(1.1, 1.1);
    }

    private JPanel getLeftPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout("fill, wrap 1"));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (Magazie magazie : this.magazii) {
            MagazieButton button = new MagazieButton(magazie, this.STANGA);
            button.setFont(this.font);
            buttonGroup.add(button);
            result.add((Component)button, "grow");
        }
        TitledBorder border = new TitledBorder("MAGAZIE SURSA");
        border.setTitleFont(this.titleFont);
        border.setTitleColor(Color.BLUE);
        result.setBorder(border);
        return result;
    }

    private JPanel getRightPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout("fill, wrap 1"));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (Magazie magazie : this.magazii) {
            MagazieButton button = new MagazieButton(magazie, this.DREAPTA);
            button.setFont(this.font);
            buttonGroup.add(button);
            result.add((Component)button, "grow");
        }
        TitledBorder border = new TitledBorder("MAGAZIE DESTINATIE");
        border.setTitleFont(this.titleFont);
        border.setTitleColor(new Color(0, 122, 0));
        result.setBorder(border);
        return result;
    }

    private void display() {
        this.setLayout((LayoutManager)new MigLayout("fill, wrap 2", "[][]", "[][][][]"));
        this.add((Component)this.getLeftPanel(), "grow, spany 3");
        this.add((Component)this.getRightPanel(), "grow, spany 3");
        JButton okButton = new JButton("OK");
        okButton.setBackground(Color.red);
        okButton.setFont(this.font);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TransferIntreMagaziiDialog.this.sursa == null) {
                    return;
                }
                if (TransferIntreMagaziiDialog.this.destinatie == null) {
                    return;
                }
                TransferIntreMagaziiDialog.this.dispose();
            }
        });
        this.add((Component)okButton, "grow");
        JButton renunta = new JButton("RENUNTA");
        renunta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransferIntreMagaziiDialog.this.sursa = (TransferIntreMagaziiDialog.this.destinatie = null);
                TransferIntreMagaziiDialog.this.dispose();
            }
        });
        renunta.setFont(this.font);
        renunta.setBackground(Color.gray);
        this.add((Component)renunta, "grow");
        int parentWidth = (int)((double)GuiUtils.currentFrame.getWidth() / this.scale);
        int parentHeight = (int)((double)GuiUtils.currentFrame.getHeight() / this.scale);
        this.parent.setSize(parentWidth, parentHeight);
        this.parent.setPreferredSize(new Dimension(parentWidth, parentHeight));
        this.parent.setMinimumSize(new Dimension(parentWidth, parentHeight));
        this.setVisible(true);
    }

    public Magazie getSursa() {
        return this.sursa;
    }

    public Magazie getDestinatie() {
        return this.destinatie;
    }

    private class MagazieButton
    extends JToggleButton {
        private final Component dis;
        private Magazie element;

        public MagazieButton(Magazie m, final int poz) {
            super(m.getLabel());
            this.dis = this;
            this.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        MagazieButton m = (MagazieButton)e.getSource();
                        Magazie element = m.getElement();
                        if (poz == TransferIntreMagaziiDialog.this.STANGA) {
                            if (!element.equals(TransferIntreMagaziiDialog.this.destinatie)) {
                                TransferIntreMagaziiDialog.this.sursa = element;
                                MagazieButton.this.dis.setForeground(Color.red);
                            } else {
                                TransferIntreMagaziiDialog.this.sursa = null;
                                MagazieButton.this.setSelected(false);
                            }
                        }
                        if (poz == TransferIntreMagaziiDialog.this.DREAPTA) {
                            if (!element.equals(TransferIntreMagaziiDialog.this.sursa)) {
                                TransferIntreMagaziiDialog.this.destinatie = element;
                                MagazieButton.this.dis.setForeground(Color.red);
                            } else {
                                TransferIntreMagaziiDialog.this.destinatie = null;
                                MagazieButton.this.setSelected(false);
                            }
                        }
                        return;
                    }
                    if (e.getStateChange() == 2) {
                        MagazieButton.this.dis.setForeground(Color.black);
                        return;
                    }
                }
            });
            this.element = m;
        }

        public Magazie getElement() {
            return this.element;
        }
    }
}

