/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui.fullscreen;

import java.awt.Color;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.image.BufferStrategy;

public class MultiBufferTest {
    private static Color[] COLORS = new Color[]{Color.red, Color.blue, Color.green, Color.white, Color.black, Color.yellow, Color.gray, Color.cyan, Color.pink, Color.lightGray, Color.magenta, Color.orange, Color.darkGray};
    private static DisplayMode[] BEST_DISPLAY_MODES = new DisplayMode[]{new DisplayMode(1280, 800, 24, 0), new DisplayMode(640, 480, 32, 0), new DisplayMode(640, 480, 16, 0), new DisplayMode(640, 480, 8, 0)};
    Frame mainFrame;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiBufferTest(int numBuffers, GraphicsDevice device) {
        try {
            GraphicsConfiguration gc = device.getDefaultConfiguration();
            this.mainFrame = new Frame(gc);
            this.mainFrame.setUndecorated(true);
            this.mainFrame.setIgnoreRepaint(true);
            device.setFullScreenWindow(this.mainFrame);
            if (device.isDisplayChangeSupported()) {
                MultiBufferTest.chooseBestDisplayMode(device);
            }
            Rectangle bounds = this.mainFrame.getBounds();
            this.mainFrame.createBufferStrategy(numBuffers);
            BufferStrategy bufferStrategy = this.mainFrame.getBufferStrategy();
            for (double lag = 2000.0; lag > (double)6.0E-8f; lag /= (double)1.33f) {
                for (int i = 0; i < numBuffers; ++i) {
                    Graphics g = bufferStrategy.getDrawGraphics();
                    if (!bufferStrategy.contentsLost()) {
                        g.setColor(COLORS[i]);
                        g.fillRect(0, 0, bounds.width, bounds.height);
                        bufferStrategy.show();
                        g.dispose();
                    }
                    try {
                        Thread.sleep((int)lag);
                        continue;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            device.setFullScreenWindow(null);
        }
    }

    private static DisplayMode getBestDisplayMode(GraphicsDevice device) {
        for (int x = 0; x < BEST_DISPLAY_MODES.length; ++x) {
            DisplayMode[] modes = device.getDisplayModes();
            for (int i = 0; i < modes.length; ++i) {
                if (modes[i].getWidth() != BEST_DISPLAY_MODES[x].getWidth() || modes[i].getHeight() != BEST_DISPLAY_MODES[x].getHeight() || modes[i].getBitDepth() != BEST_DISPLAY_MODES[x].getBitDepth()) continue;
                return BEST_DISPLAY_MODES[x];
            }
        }
        return null;
    }

    public static void chooseBestDisplayMode(GraphicsDevice device) {
        DisplayMode best = MultiBufferTest.getBestDisplayMode(device);
        if (best != null) {
            device.setDisplayMode(best);
        }
    }

    public static void main(String[] args) {
        try {
            int numBuffers = 2;
            if (args != null && args.length > 0 && ((numBuffers = Integer.parseInt(args[0])) < 2 || numBuffers > COLORS.length)) {
                System.err.println("Must specify between 2 and " + COLORS.length + " buffers");
                System.exit(1);
            }
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice device = env.getDefaultScreenDevice();
            MultiBufferTest test = new MultiBufferTest(numBuffers, device);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

