/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui.oldTable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import ro.atreides.utils.gui.EnhancedTableModel;

public class EnhancedTable
extends JTable {
    private EnhancedTableModel _valuesTableModel = null;

    public EnhancedTable(EnhancedTableModel tableModel) {
        super(tableModel);
        this._valuesTableModel = tableModel;
        this.initComponents();
    }

    private final void initComponents() {
        this.getSelectionModel().setSelectionMode(0);
        JTableHeader header = this.getTableHeader();
        header.setDefaultRenderer(new HeaderRenderer());
        header.setReorderingAllowed(false);
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int columnIndex = EnhancedTable.this.getTableHeader().getColumnModel().getColumnIndexAtX(e.getX());
                if (e.getClickCount() == 1 && columnIndex != -1) {
                    EnhancedTable.this._valuesTableModel.sortByColumn(columnIndex);
                    EnhancedTable.this.getTableHeader().repaint();
                }
            }
        });
    }

    private class HeaderRenderer
    extends DefaultTableCellRenderer {
        private final ImageIcon _ascendingIcon = new ImageIcon(ClassLoader.getSystemResource("images/sdown.gif"));
        private final ImageIcon _descendingIcon = new ImageIcon(ClassLoader.getSystemResource("images/sup.gif"));
        private JPanel _arrowReplacer;
        private final Color _headerForeground = UIManager.getColor("TableHeader.foreground");
        private final Color _headerBackground = UIManager.getColor("TableHeader.background");
        private final Border _border = UIManager.getBorder("TableHeader.cellBorder");

        public HeaderRenderer() {
            this._arrowReplacer = new JPanel();
            this._arrowReplacer.setBackground(this._headerBackground);
            this._arrowReplacer.setOpaque(true);
            Dimension size = new Dimension(this._ascendingIcon.getIconWidth(), this._ascendingIcon.getIconHeight());
            this._arrowReplacer.setMinimumSize(size);
            this._arrowReplacer.setMaximumSize(size);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            component.setForeground(this._headerForeground);
            component.setBackground(this._headerBackground);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setForeground(this._headerForeground);
            panel.setBackground(this._headerBackground);
            panel.setBorder(this._border);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 0;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.fill = 0;
            c.insets = new Insets(0, 0, 0, 0);
            panel.add(component, c);
            if (EnhancedTable.this._valuesTableModel.isSortedByColumn(column)) {
                c.weightx = 0.0;
                c.gridx = 0;
                c.insets = new Insets(0, 2, 0, 0);
                this._arrowReplacer.setBackground(Color.blue);
                panel.add((Component)this._arrowReplacer, c);
                c.gridx = 2;
                c.insets = new Insets(0, 0, 0, 2);
                JLabel l = new JLabel(EnhancedTable.this._valuesTableModel.isSortedAscending() ? this._ascendingIcon : this._descendingIcon);
                l.setBackground(Color.green);
                panel.add((Component)l, c);
            }
            return panel;
        }
    }
}

