/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui.selector;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.selector.DataProvider2;
import ro.atreides.utils.gui.selector.SelectorData;

public class Selector2
extends JPanel {
    private DataProvider2 dp;
    private Hashtable currentPages = new Hashtable();
    private Hashtable panels = new Hashtable();
    private int maxLevel = 2;
    private boolean doClickAutomatically = false;

    public Selector2(DataProvider2 dp, boolean doClickAutomatically) {
        this.dp = dp;
        this.doClickAutomatically = doClickAutomatically;
        this.display();
    }

    public Selector2(DataProvider2 dp) {
        this.dp = dp;
        this.display();
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        this.refreshAll(null);
    }

    public void refreshAll(Object selection) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 11;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridy = 0;
        c.gridx = 0;
        this.removeAll();
        int maxLevels = this.dp.getMaxLevels();
        for (int i = 0; i < maxLevels; ++i) {
            JPanel topLevel = this.buildLevel(i, selection, true);
            ++c.gridy;
            this.add((Component)topLevel, c);
        }
        if (selection == null) {
            for (int level = 1; level < maxLevels; ++level) {
                JPanel panel = (JPanel)this.panels.get(new Integer(level));
                if (panel == null) continue;
                panel.setVisible(false);
            }
        }
    }

    private JPanel buildLevel(final int level, final Object selection, boolean resetToFirstPage) {
        for (int j = level + 1; j < this.dp.getMaxLevels(); ++j) {
            JPanel panel = (JPanel)this.panels.get(new Integer(j));
            if (panel == null) continue;
            panel.setVisible(false);
        }
        JPanel result = new JPanel(new GridBagLayout());
        if (this.panels.get(new Integer(level)) != null) {
            result = (JPanel)this.panels.get(new Integer(level));
        } else {
            this.panels.put(new Integer(level), result);
        }
        result.setVisible(true);
        result.removeAll();
        final GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 11;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridy = 0;
        c.gridx = 0;
        int linesPerPage = this.dp.getLinesPerPage(level);
        int itemsPerLine = this.dp.getItemsPerLine(level);
        Vector data = this.dp.getData(level, selection);
        if (data != null) {
            boolean mustPaginate = false;
            if (linesPerPage * itemsPerLine < data.size()) {
                mustPaginate = true;
            }
            int lastPage = 0;
            if (data.size() >= linesPerPage * itemsPerLine) {
                lastPage = data.size() == linesPerPage * itemsPerLine ? data.size() / (linesPerPage * itemsPerLine) - 1 : data.size() / (linesPerPage * itemsPerLine);
            }
            int currentPage = 0;
            if (mustPaginate) {
                Object page = this.currentPages.get(new Integer(level));
                if (page != null && !resetToFirstPage) {
                    currentPage = (Integer)this.currentPages.get(new Integer(level));
                } else {
                    this.currentPages.put(new Integer(level), new Integer(currentPage));
                }
            } else {
                this.currentPages.remove(new Integer(level));
            }
            int startAt = currentPage * linesPerPage * itemsPerLine;
            int stopAt = (currentPage + 1) * linesPerPage * itemsPerLine;
            int startGrid = 0;
            if (mustPaginate) {
                startGrid = 1;
            }
            c.gridx = startGrid;
            AbstractButton firstButton = null;
            final Vector<JButton> buttons = new Vector<JButton>();
            int lines = 0;
            for (int i = startAt; i < data.size() && i < stopAt; ++i) {
                final SelectorData current = (SelectorData)data.elementAt(i);
                String toString = "<html><center>" + current.toString() + "</center></html>";
                final JButton btn = new JButton(toString);
                if (i == startAt) {
                    firstButton = btn;
                }
                btn.setFont(new Font(null, this.dp.getFontStyle(level), this.dp.getFontSize(level)));
                if (current.getColor() != null) {
                    btn.setBackground(current.getColor());
                    int reverseColor = GuiUtils.negateColor(current.getColor()).getRGB();
                    btn.setForeground(new Color(reverseColor));
                }
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (current != null) {
                            Selector2.this.buildLevel(level + 1, current, true);
                            ++c.gridy;
                            Selector2.this.clearColor(buttons);
                            btn.setForeground(Color.RED);
                        }
                    }
                });
                buttons.add(btn);
                result.add((Component)btn, c);
                btn.setFocusable(false);
                int minHeight = this.dp.getMinBtnHeight(level + 1);
                int minWidth = this.dp.getMinBtnWidth(level + 1);
                if (minHeight > 0 && minWidth > 0) {
                    Dimension currentSize = btn.getSize();
                    currentSize.setSize(minWidth, minHeight);
                    btn.setMinimumSize(currentSize);
                    btn.setPreferredSize(currentSize);
                }
                ++c.gridx;
                if (c.gridx - startGrid != itemsPerLine) continue;
                c.gridx = startGrid;
                ++c.gridy;
                ++lines;
            }
            if (mustPaginate) {
                c.gridy = 0;
                c.fill = 3;
                c.gridheight = lines;
                c.weightx = 0.0;
                c.weighty = 1.0;
                c.gridx = 0;
                JButton prev = new JButton("<<");
                prev.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        Selector2.this.prevPage(level, selection);
                    }
                });
                if (this.getCurrentPage(level) == 0) {
                    prev.setEnabled(false);
                }
                result.add((Component)prev, c);
                c.gridx = startGrid + this.dp.getItemsPerLine(level);
                JButton next = new JButton(">>");
                next.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        Selector2.this.nextPage(level, selection);
                    }
                });
                if (this.getCurrentPage(level) == lastPage) {
                    next.setEnabled(false);
                }
                result.add((Component)next, c);
            }
            if (this.doClickAutomatically && firstButton != null && level < this.maxLevel - 1) {
                firstButton.doClick();
            }
        }
        result.setVisible(false);
        result.setVisible(true);
        return result;
    }

    private void clearColor(Vector buttons) {
        for (int i = 0; i < buttons.size(); ++i) {
            JButton jButton = (JButton)buttons.elementAt(i);
            jButton.setForeground(Color.BLACK);
        }
    }

    private int getCurrentPage(int level) {
        int currentPage = (Integer)this.currentPages.get(new Integer(level));
        return currentPage;
    }

    public void switchPage(int level, int quantity) {
        int currentPage = this.getCurrentPage(level);
        this.currentPages.put(new Integer(level), new Integer(currentPage += quantity));
    }

    private void prevPage(int level, Object selection) {
        this.switchPage(level, -1);
        this.buildLevel(level, selection, false);
    }

    private void nextPage(int level, Object selection) {
        this.switchPage(level, 1);
        this.buildLevel(level, selection, false);
    }
}

