/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.DoubleClicked;

public abstract class AbstractListPanel
extends ReflectedJPanel {
    protected DoubleClicked action;
    protected AbstractTM tm;
    protected JTable table;
    protected JScrollPane scrollPane;

    public final void setAction(DoubleClicked action) {
        this.action = action;
    }

    public abstract AbstractTM buildTableModel();

    public abstract JPanel getBottomPanel();

    public AbstractTM getTm() {
        return this.tm;
    }

    protected void display() {
        this.display(false);
    }

    protected void display(boolean scrool) {
        this.tm = this.buildTableModel();
        this.table = new JTable(this.tm);
        if (scrool) {
            this.table.setAutoResizeMode(0);
        }
        this.table.setSelectionMode(0);
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow = AbstractListPanel.this.table.rowAtPoint(e.getPoint());
                if (selRow != -1 && e.getClickCount() == 2) {
                    Object toEdit = AbstractListPanel.this.tm.getObjectAt(selRow);
                    if (AbstractListPanel.this.action != null) {
                        AbstractListPanel.this.action.doubleClicked(toEdit);
                    }
                }
            }
        });
        this.tm.refresh(this.buildData());
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 0, 2, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 1.0;
        this.scrollPane = new JScrollPane(this.table);
        this.add((Component)this.scrollPane, c);
        c.weighty = 0.0;
        JPanel bottomPanel = this.getBottomPanel();
        if (bottomPanel != null) {
            ++c.gridy;
            this.add((Component)bottomPanel, c);
        }
    }

    public void refreshTable() {
        Vector newData = this.buildData();
        this.tm.refresh(newData);
    }

    public abstract Vector buildData();

    public abstract String[] buildColumns();

    public abstract Class[] buildTypes();

    public JTable getJTable() {
        return this.table;
    }
}

