/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui.table;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import ro.atreides.utils.gui.table.ColumnSizeProvider;
import ro.atreides.utils.gui.table.TmInterface;

public class AbstractTM
extends AbstractTableModel
implements ColumnSizeProvider {
    private String[] columns;
    private Class[] _columnTypes;
    private Vector data;
    private TmInterface inter;

    public AbstractTM(String[] columns, Class[] classes, TmInterface inter) {
        this.columns = columns;
        this.inter = inter;
        this._columnTypes = classes;
        this.setData(new Vector());
    }

    public void refresh(Vector newData) {
        this.setData(newData);
        this.fireTableDataChanged();
    }

    private void setData(Vector newData) {
        this.data = newData != null ? newData : new Vector();
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.inter.getValueAt(rowIndex, columnIndex, this.data);
    }

    @Override
    public String getColumnName(int column) {
        return this.columns[column];
    }

    public Object getObjectAt(int rowIndex) {
        if (rowIndex > this.data.size() || rowIndex < 0) {
            return null;
        }
        return this.data.elementAt(rowIndex);
    }

    public void setObjectAt(int rowIndex, Object newValue) {
        if (rowIndex > this.data.size() || rowIndex < 0) {
            return;
        }
        this.data.setElementAt(newValue, rowIndex);
    }

    public Vector getData() {
        return this.data;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.inter.isCellEditable(rowIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.inter.setValueAt(aValue, rowIndex, columnIndex, this.data);
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex >= this._columnTypes.length) {
            return String.class;
        }
        return this._columnTypes[columnIndex];
    }

    @Override
    public int getColumnSize(int column) {
        return 1;
    }
}

