/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.table.SortOrder;

public class SortableHeaderRenderer
extends DefaultTableCellRenderer {
    private final ImageIcon _ascendingIcon;
    private final ImageIcon _descendingIcon;
    private JPanel _arrowReplacer;
    private final Color _headerForeground;
    private final Color _headerBackground;
    private final Border _border;
    private SortOrder sortOrder;

    public SortableHeaderRenderer(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
        this._ascendingIcon = Utils.getImageResource("sdown.gif");
        this._descendingIcon = Utils.getImageResource("sup.gif");
        this._headerForeground = UIManager.getColor("TableHeader.foreground");
        this._headerBackground = UIManager.getColor("TableHeader.background");
        this._border = UIManager.getBorder("TableHeader.cellBorder");
        this._arrowReplacer = new JPanel();
        this._arrowReplacer.setBackground(this._headerBackground);
        this._arrowReplacer.setOpaque(true);
        Dimension size = new Dimension(this._ascendingIcon.getIconWidth(), this._ascendingIcon.getIconHeight());
        this._arrowReplacer.setMinimumSize(size);
        this._arrowReplacer.setMaximumSize(size);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        component.setForeground(this._headerForeground);
        component.setBackground(this._headerBackground);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setForeground(this._headerForeground);
        panel.setBackground(this._headerBackground);
        panel.setBorder(this._border);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add(component, c);
        if (this.sortOrder.isSortedByColumn(column)) {
            c.weightx = 0.0;
            c.gridx = 0;
            c.gridx = 2;
            c.insets = new Insets(0, 0, 0, 2);
            JLabel l = new JLabel(this.sortOrder.isSortedAscending() ? this._descendingIcon : this._ascendingIcon);
            l.setBackground(Color.green);
            panel.add((Component)l, c);
        }
        return panel;
    }
}

