/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui.xcombo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.gui.xcombo.ComboBoxFilter;

public class FilterableComboBoxModel
extends AbstractListModel
implements ComboBoxModel {
    private Map<Integer, Object> _data = Collections.synchronizedMap(new LinkedHashMap());
    private Hashtable<Integer, Hashtable<Integer, Integer>> allFilteredIndexes = new Hashtable();
    private Object _selectedObject;
    private ComboBoxFilter filter;
    private int lastCharPositions = 0;

    public FilterableComboBoxModel(List objects) {
        this.refresh(objects);
    }

    @Override
    public Object getSelectedItem() {
        if (this._selectedObject == null) {
            return null;
        }
        int iMax = this.getSize();
        for (int i = 0; i < iMax; ++i) {
            if (!this._selectedObject.equals(this.getElementAt(i))) continue;
            return this._selectedObject;
        }
        return this._selectedObject;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        boolean equals = false;
        if (this._selectedObject != null) {
            equals = this._selectedObject.equals(anItem);
        } else {
            boolean bl = equals = anItem == null;
        }
        if (!equals) {
            this._selectedObject = anItem;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    @Override
    public synchronized Object getElementAt(int index) {
        if (index == -1) {
            return null;
        }
        if (index >= this._data.size()) {
            return null;
        }
        Hashtable<Integer, Integer> ht = this.allFilteredIndexes.get(new Integer(this.lastCharPositions));
        ArrayList<Integer> v = new ArrayList<Integer>(ht.values());
        Integer i = v.get(index);
        return this._data.get(i);
    }

    @Override
    public synchronized int getSize() {
        Hashtable<Integer, Integer> ht = this.allFilteredIndexes.get(new Integer(this.lastCharPositions));
        if (ht != null) {
            return ht.size();
        }
        return 0;
    }

    public void setFilter(ComboBoxFilter filter) {
        this.filter = filter;
    }

    public final synchronized void applyFilters(String text) {
        int charsInString = text.length();
        Hashtable<Integer, Integer> currentFilteredIndexes = new Hashtable<Integer, Integer>();
        Hashtable<Integer, Integer> previousFilteredIndexes = this.allFilteredIndexes.get(new Integer(charsInString - 1));
        int iMax = this._data.size();
        for (int i = 0; i < iMax; ++i) {
            Object obj;
            Integer integ = new Integer(i);
            boolean fullSearch = false;
            if (previousFilteredIndexes == null || previousFilteredIndexes.size() == 0) {
                fullSearch = true;
            }
            if (!fullSearch && previousFilteredIndexes.get(integ) == null || !this.applyFilter(obj = this._data.get(integ))) continue;
            currentFilteredIndexes.put(integ, integ);
        }
        String s1 = Formatters.TIME_FORMAT_SECS.format(new Date());
        if (currentFilteredIndexes.size() == 0 && previousFilteredIndexes != null) {
            for (Integer o : previousFilteredIndexes.keySet()) {
                Object obj = this._data.get(o);
                System.out.println(obj);
            }
        }
        this.allFilteredIndexes.put(new Integer(charsInString), currentFilteredIndexes);
        this.lastCharPositions = charsInString;
        this.fireContentsChanged(this, 0, this.allFilteredIndexes.get(new Integer(this.lastCharPositions)).size() - 1);
    }

    private boolean applyFilter(Object obj) {
        if (this.filter != null) {
            return this.filter.filter(obj);
        }
        return true;
    }

    public void refresh(List objects) {
        this._data.clear();
        for (int i = 0; i < objects.size(); ++i) {
            Object o = objects.get(i);
            this._data.put(new Integer(i), o);
        }
    }
}

