/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.licensing;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JDialog;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import ro.atreides.ecr.EcrLicensePanel;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.utils.AbstractAppInit;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.DatabaseManager;
import ro.atreides.utils.documente.DocumenteLogic;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.FileDialog;
import ro.atreides.utils.licensing.LicenseVerifier;
import ro.atreides.utils.licensing.LicensingPanels;
import ro.atreides.utils.licensing.LicensingXmlHandler;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.tracking.TrackingLogic;
import ro.atreides.xmllauncher.XmlLauncher;
import ro.deversoft.licensing.ExportConstants;
import ro.deversoft.licensing.ExportEnums;
import ro.deversoft.licensing.ExportLicense;
import ro.deversoft.licensing.ExportLicenseInterface;
import ro.deversoft.licensing.ExportUtils;
import ro.deversoft.licensing.JsonLicenseVerifier;
import ro.deversoft.licensing.LicenseBean;
import ro.deversoft.licensing.LicenseBeanInterface;
import ro.deversoft.licensing.LicensingBean;
import ro.deversoft.licensing.LicensingInterface;
import ro.deversoft.licensing.LicensingJsonHandler;
import ro.deversoft.licensing.LicensingJsonHandlerInterface;
import ro.deversoft.licensing.ResellerKey;

public class LicenseManager
extends LangRoAll {
    private static final String TAG = LicenseManager.class.getSimpleName();
    private static LicenseManager instance = null;
    private static final int VERIFY_APPLICATIONS_RESULT__ALL_OK = 0;
    private static final int VERIFY_APPLICATIONS_RESULT__APPLICATION_EXPIRED = 1;
    private static final int VERIFY_APPLICATIONS_RESULT__SOME_APPLICATIONS_GRACED = 2;
    private static final int VERIFY_APPLICATIONS_RESULT__SOME_APPLICATIONS_ALERT = 3;
    private static final int VERIFY_APPLICATIONS_RESULT__INCORRECT_DATE_FORMAT = 4;
    private static final String MODULES_URL = "http://arhiva.deversoft.ro/modules.txt";
    private static final String APPS_URL = "http://arhiva.deversoft.ro/apps.txt";
    public static Vector configGroups;
    public static Vector licensedFunctions;
    public static Hashtable<String, String> licensingHash;
    private Vector validPanels = new Vector();
    private static final String develHdd1 = "S1DBNSBF227163D";
    private static final String develHdd2 = "S2R6NX0H858621T";
    public static final String ANY_HDD = "ANY";
    public static final String JSON_LICENSING_CONFIG_NAME = "jsonLicensing";
    public static Date licenseDate;

    public String getLicenseFileName(String suffix) {
        String correctName = "";
        String computerName = Utils.getLocalComputerName().trim();
        Vector pcs = Utils.splitString(computerName, ' ');
        for (String piece : pcs) {
            correctName = correctName + piece;
        }
        String licenseName = "license_" + correctName + suffix;
        System.out.println("LicenseName : " + licenseName);
        Logger.logDebug(this, "LicenseName : " + licenseName);
        return licenseName;
    }

    private LicenseManager() {
    }

    public static synchronized LicenseManager getInstance() {
        if (instance == null) {
            instance = new LicenseManager();
        }
        return instance;
    }

    private boolean reloadLicenceFileWrapper(String selectedFile, boolean differentSystem, boolean cmdLine, boolean jsonLicensing, String localComputerName) {
        boolean result = this.reloadLicenceFile1(selectedFile, differentSystem, cmdLine, jsonLicensing, localComputerName);
        if (result) {
            String propertyName = "licensing_request_" + Utils.localComputerName;
            Config.getInstance().updateValueAndCommit(propertyName, "");
        }
        return result;
    }

    private boolean reloadLicenceFile1(String selectedFile, boolean differentSystem, boolean cmdLine, boolean jsonLicensing, String localComputerName) {
        File f = new File(selectedFile);
        if (f.exists() && f.isFile()) {
            String lastSequenceS;
            StringBuffer sequenceSB = new StringBuffer();
            String[] splitFileName = f.getName().split("\\.");
            String ext = splitFileName[splitFileName.length - 1];
            boolean checksumok = false;
            boolean isJson = false;
            if (ext.equals("xml")) {
                checksumok = LicenseVerifier.verifyChecksum(selectedFile, sequenceSB);
                isJson = false;
            } else if (ext.equals("json")) {
                checksumok = JsonLicenseVerifier.verifyChecksum(f, sequenceSB, localComputerName);
                isJson = true;
            }
            if (!checksumok) {
                String message = "Checksum incorect. Contactati distribuitorul!";
                if (cmdLine) {
                    System.out.println(message);
                } else {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, message, "Eroare fatala!");
                }
                return false;
            }
            int seqDB = -1;
            String propertyName = "licensing_sequence";
            if (Validators.correctString(localComputerName)) {
                propertyName = propertyName + "_" + localComputerName;
            }
            if (Validators.correctInteger(lastSequenceS = Config.getInstance().getString(propertyName))) {
                seqDB = Integer.parseInt(lastSequenceS);
            }
            String s = sequenceSB.toString();
            int seqFile = -1;
            if (Validators.correctInteger(s)) {
                seqFile = Integer.parseInt(s);
            }
            if (seqFile <= seqDB) {
                String message = "Secventa deja folosita. Contactati distribuitorul!";
                if (cmdLine) {
                    System.out.println(message);
                } else {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, message, "Eroare fatala!");
                }
                return false;
            }
            if (ext.equals("json") && !jsonLicensing) {
                Config.getInstance().updateValueAndCommit(JSON_LICENSING_CONFIG_NAME, "1");
            }
            return this.addLicenseToDb(selectedFile, seqFile, differentSystem, cmdLine, isJson, localComputerName);
        }
        if (cmdLine) {
            System.out.println("FISIER INCORECT !!");
        } else {
            DialogUtils.errorDialog(GuiUtils.currentFrame, "Fisier incorect", "Eroare fatala!");
        }
        return false;
    }

    private void logExpiryDateForApps(Vector<LicensingBean> applications, Date generatedAt, String localAddresses, String trackingType) {
        for (LicensingBean application : applications) {
            String name = application.getName();
            String daysS = application.getValue();
            if (!Validators.correctInteger(daysS)) {
                TrackingLogic.getInstance().addLicenseTracking("errors", name + " : days not a number", localAddresses);
                continue;
            }
            int days = Integer.parseInt(daysS);
            Date expiryDate = DateUtils.addDaysToDate(generatedAt, days);
            String expireAt = name + " " + Formatters.DATE_AND_TIME_FORMAT.format(expiryDate);
            TrackingLogic.getInstance().addLicenseTracking(trackingType, expireAt, localAddresses);
        }
    }

    public void verifyLicense() {
        boolean jsonLicensing = false;
        try {
            jsonLicensing = Config.getInstance().getBooleanNoCommit(JSON_LICENSING_CONFIG_NAME);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        String licensePath = jsonLicensing ? this.saveLicenseFileOnDisk(".json") : this.saveLicenseFileOnDisk(".xml");
        String codHdd = null;
        try {
            codHdd = LicenseVerifier.getHddID();
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            Utils.systemExit();
        }
        if (licensePath == null) {
            if (jsonLicensing) {
                LicenseManager.getInstance().requestNewLicense(false);
            }
            this.requestLicenseFileFromUser(true, codHdd, true, true, jsonLicensing);
        }
        TrackingLogic.getInstance().addLicenseTracking("hddid", codHdd + "", AbstractAppInit.ipAddressesString);
        this.checkGlobalConfigs();
        if (licensePath != null) {
            if (licensePath.contains(".xml")) {
                if (jsonLicensing) {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, "Sistemul a fost modificat. Incarcati licenta de tip JSON!", "Atentie!");
                    this.requestLicenseFileFromUser(false, codHdd, true, true, jsonLicensing);
                } else {
                    this.verifyLicense(licensePath, new LicensingXmlHandler(), jsonLicensing);
                }
            } else if (licensePath.contains(".json")) {
                this.verifyLicense(licensePath, new LicensingJsonHandler(this.getLicenseJsonHandlerInterface()), jsonLicensing);
            } else {
                DialogUtils.errorDialog(GuiUtils.currentFrame, "Format de fisier de licenta necunoscut!", "Atentie!");
                Utils.systemExit();
            }
        } else {
            DialogUtils.errorDialog(GuiUtils.currentFrame, "Incarcati fisierul de licenta pe server. Licenta inexistenta", "Atentie!");
            Utils.systemExit();
        }
    }

    private LicenseBean getExistingLicenseBean() {
        LicenseBean bean = null;
        if (bean == null) {
            LicenseBeanInterface beanInterface = new LicenseBeanInterface(){

                @Override
                public Date getExpireDate() {
                    return DateUtils.addDaysToDate(new Date(), 366);
                }

                @Override
                public String getBrand() {
                    return VpConfig.getInstance().entityName;
                }

                @Override
                public String getSocietate() {
                    return VpConfig.getInstance().societate;
                }

                @Override
                public String getCui() {
                    return VpConfig.getInstance().cui;
                }

                @Override
                public String getPCName() {
                    return Utils.localComputerName;
                }

                @Override
                public String getDBId() {
                    return VpConfig.getInstance().bdID;
                }

                @Override
                public String getClientName() {
                    return VpConfig.getInstance().clientName;
                }

                @Override
                public String getHDDId() {
                    String hddID = null;
                    try {
                        hddID = LicenseVerifier.getHddID();
                    }
                    catch (IOException e) {
                        DialogUtils.errorDialog(GuiUtils.currentFrame, "Dispozitiv fara hdd id! Programul se va inchide", LangRoAll.eroare);
                        Utils.systemExit();
                    }
                    return hddID;
                }

                @Override
                public int getCurrentSequence() {
                    try {
                        Integer sequence = LicenseManager.this.getLastSequenceFromDb(Utils.localComputerName);
                        return sequence;
                    }
                    catch (SQLException e) {
                        Logger.logException(this, (Exception)e);
                        return 1;
                    }
                }

                @Override
                public String getMajorVersion() {
                    return DatabaseManager.getInstance().getMajorVersion() + "";
                }

                @Override
                public String getEmailAddress() {
                    return "";
                }

                @Override
                public String getMobileNumber() {
                    return "";
                }

                @Override
                public String getChosenApp() {
                    return "";
                }

                @Override
                public Vector<String> getChosenModules() {
                    return new Vector<String>();
                }
            };
            bean = ExportLicense.composeNewLicenseBean(beanInterface);
        }
        return bean;
    }

    public void requestNewLicense(final boolean exit) {
        final LicenseManager licenseManager = this;
        LicenseBean existingData = this.getExistingLicenseBean();
        ExportLicenseInterface licenseInterface = new ExportLicenseInterface(){

            @Override
            public void showErrorDialog(String message, String title) {
                DialogUtils.errorDialog(GuiUtils.currentFrame, message, title);
            }

            @Override
            public void showOkDialog(String message, String title) {
                DialogUtils.okDialog(GuiUtils.currentFrame, message, title);
            }

            @Override
            public boolean canAddLicenseRequest() {
                return licenseManager.canAddLicenseRequest();
            }

            @Override
            public void checkGlobalConfigs() {
                licenseManager.checkGlobalConfigs();
            }

            @Override
            public void registerLicenseRequest(ExportLicense.RequestType rType, long licenseRequestId) {
                if (licenseRequestId > 0L) {
                    licenseManager.registerLicenseRequest(rType);
                    if (exit) {
                        DialogUtils.okDialog(GuiUtils.currentFrame, "Programul se va inchide. Porniti programul manual ! ", LangRoAll.atentie);
                        Utils.systemExit();
                    }
                } else {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, LangRoAll.operatieEsuata, LangRoAll.nuPotContinua);
                }
            }

            @Override
            public void openOnlineShopUrl(String url) {
                boolean openOk = GuiUtils.openLinkInBrowser(url);
                if (!openOk) {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, "Deschideti MANUAL linkul " + url + " !!! ", LangRoAll.atentie);
                }
            }
        };
        EcrLicensePanel panel = new EcrLicensePanel(existingData, APPS_URL, MODULES_URL);
        JDialog dialog = DialogUtils.getJDialog(panel, GuiUtils.currentFrame, "Cerere licenta", 1.2);
        panel.setDialog(dialog);
        dialog.setVisible(true);
        ResellerKey resellerKey = ResellerKey.getResellerKeyFromFile("reseller_key.json");
        LicenseBean resultLicense = panel.getResultLicense();
        if (resultLicense != null) {
            ExportLicense.getInstance().requestNewLicense(resultLicense, licenseInterface, resellerKey);
        }
    }

    private boolean verifyProperties(String licenseHddId, int mainVersion) {
        String s1;
        Integer majorVersionDb;
        boolean result = true;
        String deviceId = null;
        try {
            deviceId = LicenseVerifier.getHddID();
        }
        catch (IOException e) {
            deviceId = "bloody sdcard drive";
            e.printStackTrace();
        }
        if (!licenseHddId.equals(ANY_HDD) && !licenseHddId.equals(deviceId)) {
            result = false;
        }
        if ((majorVersionDb = DatabaseManager.getInstance().getMajorVersion()) == null) {
            TrackingLogic.getInstance().addLicenseTracking("major_version", "db=null", AbstractAppInit.ipAddressesString);
            s1 = "DB Major Version is null!! Contactati suportul tehnic!!";
            Logger.logError((Object)this, s1);
            System.out.println(s1);
            DialogUtils.errorDialog(null, s1, LangRoAll.nuPotContinua);
            Utils.systemExit();
        }
        if (mainVersion != majorVersionDb) {
            s1 = "DB Major Version differs from XML Major Version!!";
            Logger.logError((Object)this, s1);
            System.out.println(s1);
            DialogUtils.errorDialog(null, s1, LangRoAll.atentie);
            this.loadNewLicenseAttempt(true, true, true);
            Utils.systemExit();
        }
        return result;
    }

    private void checkGlobalConfigs() {
        try {
            String errorMessage = "Textul introdus nu trebuie sa contina spatii!";
            for (Config.GlobalConfigs config : Config.GlobalConfigs.values()) {
                String configValue = Config.getInstance().getStringNoCommit(config.name(), "");
                if (!configValue.isEmpty()) continue;
                String inputName = " ";
                while (inputName.contains(" ")) {
                    inputName = DialogUtils.inputDialog(GuiUtils.currentFrame, "", config.getMessage());
                    if (!inputName.contains(" ")) continue;
                    DialogUtils.errorDialog(GuiUtils.currentFrame, errorMessage, "Atentie!");
                }
                Config.getInstance().updateValueAndCommit(config.name(), inputName);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private LicensingJsonHandlerInterface getLicenseJsonHandlerInterface() {
        return new LicensingJsonHandlerInterface(){

            @Override
            public String getLocalComputerName() {
                return Utils.localComputerName;
            }

            @Override
            public void notifyUserError(String text, String title) {
                DialogUtils.errorDialog(GuiUtils.currentFrame, text, title);
                Utils.systemExit();
            }

            @Override
            public void notifyUserErrorAndRecord(String text, String title) {
                TrackingLogic.getInstance().addLicenseTracking("errors", text, AbstractAppInit.ipAddressesString);
            }
        };
    }

    public void verifyLicense(String licensePath, LicensingInterface handler, boolean jsonLicensing) {
        try {
            String s1;
            boolean canAddApp;
            int result;
            String s;
            LicensingBean licensingBean;
            int i;
            handler.load(licensePath);
            TrackingLogic.getInstance().addLicenseTracking("license_name", handler.getLicenceFileId(), AbstractAppInit.ipAddressesString);
            TrackingLogic.getInstance().addLicenseTracking("license_sequence", handler.getSequence(), AbstractAppInit.ipAddressesString);
            TrackingLogic.getInstance().addLicenseTracking("license_checksum", handler.getChecksum(), AbstractAppInit.ipAddressesString);
            Vector<LicensingBean> allAplications = handler.getApplications();
            Vector<LicensingBean> allModules = handler.getModules();
            Vector<LicensingBean> clientProperties = handler.getClientProperties();
            Vector<LicensingBean> systemProperties = handler.getSystemProperties();
            try {
                String s2 = handler.getGeneratedAt();
                if (s2 != null) {
                    Date now;
                    licenseDate = Formatters.DATE_AND_TIME_FORMAT.parse(s2);
                    if (!licenseDate.before(now = new Date())) {
                        String nowS = Formatters.DATE_AND_TIME_FORMAT.format(now);
                        String s12 = "Data curenta [" + nowS + "] < data generare [" + s2 + "]";
                        System.out.println(s12);
                        Logger.logError((Object)this, s12);
                        TrackingLogic.getInstance().addLicenseTracking("theft", s12, AbstractAppInit.ipAddressesString);
                        Utils.systemExit();
                    }
                } else {
                    try {
                        String codHdd2 = LicenseVerifier.getHddID();
                        this.requestLicenseFileFromUser(true, codHdd2, true, true, jsonLicensing);
                    }
                    catch (IOException e1) {
                        Logger.logException(this, (Exception)e1);
                        Utils.systemExit();
                    }
                }
            }
            catch (ParseException e) {
                Logger.logException(this, (Exception)e);
                String err = "Data generare incorecta, Actualizati LICENTA ( Licenta veche ) !!";
                System.out.println(err);
                Logger.logError((Object)this, err);
                TrackingLogic.getInstance().addLicenseTracking("errors", err, AbstractAppInit.ipAddressesString);
                Utils.systemExit();
            }
            this.logExpiryDateForApps(allAplications, licenseDate, AbstractAppInit.ipAddressesString, "license_expiry_app");
            this.logExpiryDateForApps(allModules, licenseDate, AbstractAppInit.ipAddressesString, "license_expiry_module");
            Vector<String> licensedApplications = new Vector<String>();
            Vector<String> licensedModules = new Vector<String>();
            Vector<String> excludedModules = new Vector<String>();
            boolean systemOK = this.verifySystemProperties(systemProperties);
            if (!systemOK) {
                String s13 = "Licenta nu corespunde sistemului !! Eroare fatala!";
                TrackingLogic.getInstance().addLicenseTracking("theft", s13, AbstractAppInit.ipAddressesString);
                DialogUtils.errorDialog(GuiUtils.currentFrame, s13, "Contactati distribuitorul!");
                this.loadNewLicenseAttempt(true, true, true);
            }
            boolean errors = false;
            boolean someExpired = false;
            boolean someGraced = false;
            boolean someAlert = false;
            for (i = 0; i < allAplications.size(); ++i) {
                licensingBean = allAplications.elementAt(i);
                s = licensingBean.getValue();
                if (!Validators.correctInteger(s)) {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, "Licenta invalida !! Eroare fatala!", "Contactati distribuitorul!");
                    errors = true;
                    continue;
                }
                result = this.verifyApplication(licensingBean.getName(), licensingHash);
                canAddApp = false;
                switch (result) {
                    case 1: {
                        someExpired = true;
                        break;
                    }
                    case 4: {
                        errors = true;
                        break;
                    }
                    case 2: {
                        someGraced = true;
                        canAddApp = true;
                        break;
                    }
                    case 3: {
                        someAlert = true;
                        canAddApp = true;
                        break;
                    }
                    case 0: {
                        canAddApp = true;
                    }
                }
                if (!canAddApp) continue;
                licensedApplications.add(licensingBean.getName());
            }
            for (i = 0; i < allModules.size(); ++i) {
                licensingBean = allModules.elementAt(i);
                s = licensingBean.getValue();
                if (!Validators.correctInteger(s)) {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, "Licenta invalida !! Eroare fatala!", "Contactati distribuitorul!");
                    errors = true;
                    continue;
                }
                result = this.verifyModule(licensingBean.getName(), licensingHash);
                canAddApp = false;
                switch (result) {
                    case 1: {
                        someExpired = true;
                        break;
                    }
                    case 4: {
                        errors = true;
                        break;
                    }
                    case 2: {
                        someGraced = true;
                        canAddApp = true;
                        break;
                    }
                    case 3: {
                        someAlert = true;
                        canAddApp = true;
                        break;
                    }
                    case 0: {
                        canAddApp = true;
                    }
                }
                if (!canAddApp) continue;
                if (licensingBean.getName().startsWith("-")) {
                    excludedModules.add(licensingBean.getName().substring(1));
                    continue;
                }
                licensedModules.add(licensingBean.getName());
            }
            if (errors || someExpired || someGraced || someAlert) {
                this.loadNewLicenseAttempt(false, true, false);
            }
            if (licensedApplications.size() > 0) {
                this.buildValidPanels(licensedApplications, licensedModules, excludedModules);
            } else {
                DialogUtils.errorDialog(GuiUtils.currentFrame, "Nici o aplicatie licentiata !! ", "Contactati distribuitorul!");
                Utils.systemExit();
            }
            Integer majorVersionXml = handler.getMajorVersion();
            Integer majorVersionDb = DatabaseManager.getInstance().getMajorVersion();
            if (majorVersionDb == null) {
                TrackingLogic.getInstance().addLicenseTracking("major_version", "db=null", AbstractAppInit.ipAddressesString);
                s1 = "DB Major Version is null !! Contactati suportul tehnic !!";
                Logger.logError((Object)this, s1);
                System.out.println(s1);
                DialogUtils.errorDialog(null, s1, LangRoAll.nuPotContinua);
                Utils.systemExit();
            }
            if (!majorVersionDb.equals(2017)) {
                s1 = "DB Major Version differs from LIBRARIES Major Version !!";
                Logger.logError((Object)this, s1);
                System.out.println(s1);
                DialogUtils.errorDialog(null, s1, LangRoAll.atentie);
                this.loadNewLicenseAttempt(true, true, true);
                Utils.systemExit();
            }
            if (majorVersionXml == null) {
                TrackingLogic.getInstance().addLicenseTracking("major_version", "xml=null", AbstractAppInit.ipAddressesString);
                s1 = "License Major Version is null !! ";
                Logger.logError((Object)this, s1);
                System.out.println(s1);
                DialogUtils.errorDialog(null, s1, LangRoAll.atentie);
                this.loadNewLicenseAttempt(true, true, true);
                Utils.systemExit();
            }
            TrackingLogic.getInstance().addLicenseTracking("major_version", "db=" + majorVersionDb, AbstractAppInit.ipAddressesString);
            TrackingLogic.getInstance().addLicenseTracking("major_version", "xml=" + majorVersionXml, AbstractAppInit.ipAddressesString);
            if (!majorVersionDb.equals(majorVersionXml)) {
                s1 = "DB Major Version differs from XML Major Version !!";
                Logger.logError((Object)this, s1);
                System.out.println(s1);
                DialogUtils.errorDialog(null, s1, LangRoAll.atentie);
                this.loadNewLicenseAttempt(true, true, true);
                Utils.systemExit();
            }
        }
        catch (Exception e) {
            Logger.logException(this, e);
            String s = "Fisier licenta corupt. Eroare fatala!";
            DialogUtils.errorDialog(GuiUtils.currentFrame, s, "Contactati distribuitorul!");
            TrackingLogic.getInstance().addLicenseTracking("errors", s, AbstractAppInit.ipAddressesString);
        }
    }

    public void loadNewLicenseAttempt(boolean force, boolean exit, boolean differentSystem) {
        if (DialogUtils.confirmDialog(GuiUtils.currentFrame, "Incarcam alta licenta", LangRoAll.confirmare) || force) {
            try {
                String codHdd = LicenseVerifier.getHddID();
                boolean jsonLicensing = false;
                try {
                    jsonLicensing = Config.getInstance().getBooleanNoCommit(JSON_LICENSING_CONFIG_NAME);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                this.requestLicenseFileFromUser(false, codHdd, exit, differentSystem, jsonLicensing);
            }
            catch (IOException e) {
                Logger.logException(this, (Exception)e);
                Utils.systemExit();
            }
        }
    }

    public void requestFromMemshare(boolean exit, boolean extend) {
        VpConfig configInstance = VpConfig.getInstance();
        if (!this.canAddLicenseRequest()) {
            DialogUtils.okDialog(GuiUtils.currentFrame, "Deja exista o cerere in curs de procesare!", LangRoAll.actiuni);
            return;
        }
        boolean licenseRequest = false;
        if (configInstance.jsonLicensing && extend) {
            licenseRequest = this.requestJsonLicenseExtend(exit);
        } else if (!extend) {
            licenseRequest = this.loadJsonMigrationAttempt(exit, extend);
        } else {
            DialogUtils.errorDialog(GuiUtils.currentFrame, "Operatie invalida!", LangRoAll.eroare);
        }
        if (licenseRequest) {
            this.registerLicenseRequest(extend ? ExportLicense.RequestType.extend : ExportLicense.RequestType.migrate);
            DialogUtils.okDialog(GuiUtils.currentFrame, "Cererea a fost inregistrata cu succes!", LangRoAll.succes);
        } else {
            DialogUtils.errorDialog(GuiUtils.currentFrame, "Cererea nu a putut fi inregistrata! Contactati administratorul!", LangRoAll.eroare);
            if (exit) {
                Utils.systemExit();
            }
        }
    }

    public boolean isLicensed() {
        if (!DatabaseManager.getInstance().hasLicenseFiles()) {
            return false;
        }
        return DatabaseManager.getInstance().hasLicensingConfigs();
    }

    private boolean canAddLicenseRequest() {
        String propertyName = "licensing_request_" + Utils.localComputerName;
        String lastRequest = null;
        try {
            lastRequest = Config.getInstance().getStringNoCommit(propertyName, "");
            return !Validators.correctString(lastRequest);
        }
        catch (SQLException e) {
            DialogUtils.errorDialog(GuiUtils.currentFrame, e.getMessage(), LangRoAll.eroare);
            e.printStackTrace();
            return true;
        }
    }

    public boolean requestJsonLicenseExtend(boolean exit) {
        LicenseBean bean;
        String licensePath = this.saveLicenseFileOnDisk(".json");
        File licenseFile = new File(licensePath);
        String fileContent = ExportUtils.readFile(licenseFile);
        if (!Validators.correctString(fileContent)) {
            DialogUtils.errorDialog(GuiUtils.currentFrame, "Fisier de licenta invalid! Fara continut.", LangRoAll.eroare);
            if (exit) {
                Utils.systemExit();
            }
        }
        if ((bean = ExportUtils.getLicenseBeanFromJson(fileContent)) == null) {
            DialogUtils.errorDialog(GuiUtils.currentFrame, "Fisier de licenta invalid! Not Json", LangRoAll.eroare);
            if (exit) {
                Utils.systemExit();
            }
        }
        ResellerKey resellerKey = ResellerKey.getResellerKeyFromFile("reseller_key.json");
        VpConfig inst = VpConfig.getInstance();
        long memshareNodeId = ExportLicense.getInstance().exportJson(licenseFile, bean, inst.clientName, Utils.localComputerName, inst.bdID, 30, resellerKey);
        return memshareNodeId != -1L;
    }

    public boolean loadJsonMigrationAttempt(boolean exit, boolean extend) {
        ExportLicense.RequestType rType = ExportLicense.RequestType.migrate;
        if (extend) {
            rType = ExportLicense.RequestType.extend;
        }
        if (DialogUtils.confirmDialog(GuiUtils.currentFrame, "Efectuam migrare la JSON", LangRoAll.confirmare)) {
            this.checkGlobalConfigs();
            VpConfig inst = VpConfig.getInstance();
            String licensePath = this.saveLicenseFileOnDisk(".xml");
            File licenseFile = new File(licensePath);
            ResellerKey resellerKey = ResellerKey.getResellerKeyFromFile("reseller_key.json");
            Long licenseNodeId = this.exportXMLFile(licenseFile, inst.clientName, inst.bdID, Utils.localComputerName, 400, resellerKey);
            return licenseNodeId != null && licenseNodeId != -1L;
        }
        DialogUtils.errorDialog(GuiUtils.currentFrame, "Migrare anulata", LangRoAll.actiuni);
        return false;
    }

    private void registerLicenseRequest(ExportLicense.RequestType rType) {
        String propertyName = "licensing_request_" + Utils.localComputerName;
        String propertyValue = null;
        try {
            propertyValue = Config.getInstance().getStringNoCommit(propertyName, "");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (!Validators.correctString(propertyValue)) {
            Config.getInstance().addConfigCommit(propertyName, "not_set", false);
        }
        Config.getInstance().updateValueAndCommit(propertyName, rType.name());
    }

    private boolean addPeriodApplicationOrModule(String propertyName, int days, boolean differentSystem) throws SQLException {
        Date now = new Date();
        String validUntil = Config.getInstance().getStringNoCommit(propertyName);
        if (Validators.correctString(validUntil)) {
            if (!Validators.correctDate(validUntil, Formatters.DATE_AND_TIME_FORMAT)) {
                DialogUtils.errorDialog(GuiUtils.currentFrame, "Licenta invalida !! Eroare fatala!", "Contactati distribuitorul!");
                return false;
            }
            try {
                Date d = Formatters.DATE_AND_TIME_FORMAT.parse(validUntil);
                d = differentSystem ? DateUtils.addDaysToDate(now, days) : DateUtils.addDaysToDate(d, days);
                Config.getInstance().updateValueNoCommit(propertyName, Formatters.DATE_AND_TIME_FORMAT.format(d));
                return true;
            }
            catch (ParseException e) {
                Logger.logException(this, (Exception)e);
            }
        } else {
            Date d1 = DateUtils.addDaysToDate(now, days);
            validUntil = Formatters.DATE_AND_TIME_FORMAT.format(d1);
            Config.getInstance().addConfigNoCommit(propertyName, Formatters.DATE_AND_TIME_FORMAT.format(d1), false);
            return true;
        }
        return false;
    }

    private String getFullPropertyName(String appName) {
        return "licensing_" + appName + "_" + Utils.getLocalComputerName();
    }

    private String getFullPropertyNameModule(String appName) {
        return "licensing_module_" + appName + "_" + Utils.getLocalComputerName();
    }

    private boolean addPeriodApplication(String appName, int days, boolean differentSystem) throws SQLException {
        String propertyName = this.getFullPropertyName(appName);
        return this.addPeriodApplicationOrModule(propertyName, days, differentSystem);
    }

    private boolean addPeriodModule(String moduleName, int days, boolean differentSystem) throws SQLException {
        String propertyName = "licensing_module_" + moduleName + "_" + Utils.getLocalComputerName();
        return this.addPeriodApplicationOrModule(propertyName, days, differentSystem);
    }

    private int verifyApplicationOrModule(String applicationOrModuleName, String propertyName, Hashtable licenceHash) {
        Date now = new Date();
        String validUntil = Config.getInstance().getString(propertyName);
        if (!Validators.correctDate(validUntil, Formatters.DATE_AND_TIME_FORMAT)) {
            DialogUtils.errorDialog(GuiUtils.currentFrame, applicationOrModuleName + " : Format data incorect. Contactati distribuitorul!", "Eroare fatala!");
            return 4;
        }
        try {
            licenceHash.put(applicationOrModuleName, validUntil);
            Date expiryDate = Formatters.DATE_AND_TIME_FORMAT.parse(validUntil);
            Date alertDate = DateUtils.addDaysToDate(expiryDate, -7);
            Date gracedDate = DateUtils.addDaysToDate(expiryDate, 7);
            if (expiryDate.before(now)) {
                if (gracedDate.before(now)) {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, applicationOrModuleName + " : perioada de gratie expirata!", "Contactati distribuitorul!");
                    return 1;
                }
                DialogUtils.errorDialog(GuiUtils.currentFrame, applicationOrModuleName + " : sunteti in perioada de gratie!", "Contactati distribuitorul!");
                return 2;
            }
            if (alertDate.before(now)) {
                DialogUtils.errorDialog(GuiUtils.currentFrame, applicationOrModuleName + " : licenta va expira curand!", "Contactati distribuitorul!");
                return 3;
            }
        }
        catch (ParseException e) {
            Logger.logException(this, (Exception)e);
            DialogUtils.errorDialog(GuiUtils.currentFrame, applicationOrModuleName + " : Format data incorect. Contactati distribuitorul!", "Eroare fatala!");
            return 4;
        }
        return 0;
    }

    private void requestLicenseFileFromUser(boolean noLicenseAtAll, String codHdd, boolean exit, boolean differentSystem, boolean jsonLicensing) {
        String selectedFile;
        boolean ok;
        String[] licenseFilesInStartupDir;
        String title;
        String message = "Alegeti fisierul de licenta. Cod HDD \"" + codHdd + "\" , InstallName=\"" + Utils.localComputerName + "\"";
        String string = title = noLicenseAtAll ? "Licenta inexistenta !" : "Inlocuire licenta !";
        if (noLicenseAtAll && (licenseFilesInStartupDir = new File(XmlLauncher.launchingDir).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String nameLower = name.toLowerCase();
                String[] splitName = nameLower.split(".");
                if (splitName.length != 2) {
                    return false;
                }
                String fName = splitName[0];
                String extension = splitName[1];
                return !(!extension.equals("xml") && !extension.equals("json") || !nameLower.equals("licenta") && !nameLower.equals("licence") && !nameLower.equals("license"));
            }
        })) != null && licenseFilesInStartupDir.length > 0 && (ok = this.reloadLicenceFileWrapper(selectedFile = XmlLauncher.launchingDir + File.separator + licenseFilesInStartupDir[0], differentSystem, true, jsonLicensing, Utils.localComputerName))) {
            System.out.println("LICENTA INCARCATA : " + selectedFile + ". Reporniti programul !!");
            Utils.systemExit();
        }
        DialogUtils.okDialog(GuiUtils.currentFrame, message, title);
        String selectedFile2 = FileDialog.getLoadDialogLocation(null, "Selectati fisierul licenta", "xml,json");
        if (selectedFile2 != null) {
            boolean ok2 = this.reloadLicenceFileWrapper(selectedFile2, differentSystem, false, jsonLicensing, Utils.localComputerName);
            if (ok2) {
                DialogUtils.okDialog(GuiUtils.currentFrame, "Licenta va fi folosita la urmatoarea pornire", "Reporniti programul");
            } else {
                DialogUtils.errorDialog(GuiUtils.currentFrame, "Licenta invalida", "Programul se va inchide");
            }
        } else {
            DialogUtils.errorDialog(GuiUtils.currentFrame, "Fisier incorect", "Eroare fatala!");
        }
        if (exit) {
            Utils.systemExit();
        }
    }

    private String saveLicenseFileOnDisk(String suffix) {
        String filename = this.getLicenseFileName(suffix);
        int idFile = DocumenteLogic.getInstance().getIdFileByFilenameCommit(filename);
        if (idFile > 0) {
            String tmp = FileUtils.getTempDir();
            String tempLicense = tmp + File.separator + "_" + filename;
            File f = new File(tempLicense);
            DocumenteLogic.getInstance().saveDocument(f, idFile);
            if (f.exists()) {
                return f.getAbsolutePath();
            }
            return null;
        }
        Logger.logDebug(this, "No id file for filename '" + filename + "'");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addLicenseToDb(String licenseFile, int sequence, boolean differentSystem, boolean cmdLine, boolean isJson, String localComputerName) {
        boolean result = true;
        try {
            String message;
            String dbFilename = this.getLicenseFileName(isJson ? ".json" : ".xml");
            File f = new File(licenseFile);
            FileInputStream inFile = new FileInputStream(f);
            int size = (int)f.length();
            int idFile = DocumenteLogic.getInstance().getIdFileByFilenameNoCommit(dbFilename);
            String comments = "";
            if (sequence > 0) {
                comments = comments + sequence;
            }
            if (idFile > 0) {
                DocumenteLogic.getInstance().addFileVersionNoCommit(idFile, "", comments, inFile, size);
                message = "Added FileVersion , content from : " + licenseFile;
                if (cmdLine) {
                    System.out.println(message);
                }
                Logger.logDebug(this, message);
            } else {
                DocumenteLogic.getInstance().addFileNoCommit(dbFilename, dbFilename, dbFilename, comments, inFile, size);
                message = "Added File with name " + dbFilename + ", content from : " + licenseFile;
                Logger.logDebug(this, message);
                if (cmdLine) {
                    System.out.println(message);
                }
            }
            if (this.canAddFileWithGivenSequence(sequence, localComputerName)) {
                String s;
                LicensingBean licensingBean;
                int i;
                Vector<Object> allAplications = new Vector();
                Vector<Object> allModules = new Vector();
                LicensingInterface handler = isJson ? new LicensingJsonHandler(this.getLicenseJsonHandlerInterface()) : new LicensingXmlHandler();
                handler.load(licenseFile);
                allAplications = handler.getApplications();
                allModules = handler.getModules();
                for (i = 0; i < allAplications.size() && result; ++i) {
                    licensingBean = (LicensingBean)allAplications.elementAt(i);
                    s = licensingBean.getValue();
                    if (!Validators.correctInteger(s)) {
                        String message2 = licensingBean.getName() + " : days = incorect";
                        if (cmdLine) {
                            System.out.println(message2);
                        } else {
                            DialogUtils.errorDialog(GuiUtils.currentFrame, message2, "Contactati distribuitorul!");
                        }
                        result = false;
                        continue;
                    }
                    int days = Integer.parseInt(s);
                    result = result && this.addPeriodApplication(licensingBean.getName(), days, differentSystem);
                }
                for (i = 0; i < allModules.size() && result; ++i) {
                    licensingBean = (LicensingBean)allModules.elementAt(i);
                    s = licensingBean.getValue();
                    if (!Validators.correctInteger(s)) {
                        String message3 = licensingBean.getName() + " : days = incorect";
                        if (cmdLine) {
                            System.out.println(message3);
                        } else {
                            DialogUtils.errorDialog(GuiUtils.currentFrame, message3, "Contactati distribuitorul!");
                        }
                        result = false;
                        continue;
                    }
                    int days = Integer.parseInt(s);
                    result = result && this.addPeriodModule(licensingBean.getName(), days, differentSystem);
                }
            } else {
                message = "Cannot add file with sequence";
                Logger.logDebug(this, message);
                if (cmdLine) {
                    System.out.println(message);
                } else {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, "Secventa incorecta!", "Contactati distribuitorul!");
                }
                result = false;
            }
            if (result) {
                ConnectionPool.getInstance().commit();
                Logger.logDebug(this, "COMMIT");
                if (cmdLine) {
                    System.out.println("COMMIT");
                }
            } else {
                ConnectionPool.getInstance().rollBack();
                Logger.logDebug(this, "ROLLBACK");
                if (cmdLine) {
                    System.out.println("ROLLBACK");
                }
            }
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                ConnectionPool.getInstance().rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            result = false;
        }
        finally {
            ConnectionPool.getInstance().releaseConnection();
        }
        return result;
    }

    private void buildValidPanels(Vector<String> apps, Vector<String> modules, Vector<String> excludedModules) {
        int i;
        for (i = 0; i < apps.size(); ++i) {
            String app = apps.elementAt(i);
            Vector panels = LicensingPanels.getClassNamesForAppId(app);
            this.validPanels.addAll(panels);
        }
        for (i = 0; i < modules.size(); ++i) {
            String className = modules.elementAt(i);
            this.validPanels.add(className);
        }
        Vector<String> remains = new Vector<String>();
        for (int i2 = 0; i2 < this.validPanels.size(); ++i2) {
            String s = (String)this.validPanels.elementAt(i2);
            if (excludedModules.contains(s)) continue;
            remains.add(s);
        }
        this.validPanels = remains;
    }

    public boolean isGuiPanelLicenced(String className) {
        return this.validPanels.contains(className);
    }

    private int verifyApplication(String appName, Hashtable licensingHash) {
        String propertyName = this.getFullPropertyName(appName);
        return this.verifyApplicationOrModule(appName, propertyName, licensingHash);
    }

    private int verifyModule(String appName, Hashtable licensingHash) {
        String propertyName = this.getFullPropertyNameModule(appName);
        return this.verifyApplicationOrModule(appName, propertyName, licensingHash);
    }

    private boolean verifySystemProperties(Vector<LicensingBean> systemProperties) {
        try {
            boolean found = false;
            String realHdd = LicenseVerifier.getHddID();
            if (realHdd == null) {
                realHdd = "bloody sdcard drive";
            }
            if (realHdd.equalsIgnoreCase(develHdd1) || realHdd.equalsIgnoreCase(develHdd2)) {
                return true;
            }
            for (int i = 0; i < systemProperties.size() && !found; ++i) {
                String hdd2SerNumber;
                LicensingBean licensingBean = systemProperties.elementAt(i);
                String name = licensingBean.getName();
                if (name.equalsIgnoreCase("hdd1SerNumber")) {
                    String hdd1SerNumber = licensingBean.getValue();
                    if (!hdd1SerNumber.equalsIgnoreCase(ANY_HDD) && !realHdd.equals(hdd1SerNumber)) continue;
                    found = true;
                    continue;
                }
                if (!name.equalsIgnoreCase("hdd2SerNumber") || !(hdd2SerNumber = licensingBean.getValue()).equalsIgnoreCase(ANY_HDD) && !realHdd.equals(hdd2SerNumber)) continue;
                found = true;
            }
            return found;
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            DialogUtils.errorDialog(GuiUtils.currentFrame, "Configuratie sistem incorecta! Eroare fatala!", "Contactati distribuitorul!");
            Utils.systemExit();
            return false;
        }
    }

    private boolean canAddFileWithGivenSequence(int currentSeq, String computerName) throws SQLException {
        int lastSeq = this.getLastSequenceFromDb(computerName);
        if (lastSeq >= currentSeq) {
            DialogUtils.errorDialog(GuiUtils.currentFrame, "Fisier prelungire licenta deja folosit!", "Contactati distribuitorul!");
            return false;
        }
        return true;
    }

    private int getLastSequenceFromDb(String computerName) throws SQLException {
        String lastSequenceS;
        String propertyName = "licensing_sequence";
        if (Validators.correctString(computerName)) {
            propertyName = propertyName + "_" + computerName;
        }
        if (!Validators.correctInteger(lastSequenceS = Config.getInstance().getStringNoCommit(propertyName))) {
            Config.getInstance().addConfigNoCommit(propertyName, "0", false);
            return 0;
        }
        int lastSeq = Integer.parseInt(lastSequenceS);
        return lastSeq;
    }

    public boolean isFunctionLicensed(String functionkey) {
        return licensedFunctions != null && licensedFunctions.contains(functionkey);
    }

    public Long exportXMLFile(File xmlFile, String clientName, String _name, String bdName, Integer noOfDays, ResellerKey resellerKey) {
        String pcNodeTitle = LicenseManager.composePcNodeTitle(xmlFile);
        if (pcNodeTitle == null || pcNodeTitle.isEmpty()) {
            return null;
        }
        String expireDate = LicenseManager.getFutureDate(noOfDays, ExportConstants.DATE_FORMAT.toPattern());
        Map<String, List<Map<String, String>>> licenseMicrosheets = LicenseManager.getLicenseMicrosheets(xmlFile, _name, expireDate);
        Map<String, List<Map<String, String>>> bdMicrosheets = LicenseManager.getBdMicrosheets(xmlFile);
        return ExportLicense.getInstance().exportXMLFile(xmlFile, clientName, bdName, bdMicrosheets, pcNodeTitle, licenseMicrosheets, resellerKey);
    }

    public static String getFutureDate(Integer addDays, String pattern) {
        Calendar utilCalendar = Calendar.getInstance();
        utilCalendar.setTime(new Date());
        utilCalendar.add(6, addDays);
        Date returnDate = utilCalendar.getTime();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        return simpleDateFormat.format(returnDate);
    }

    public static Map<String, List<Map<String, String>>> getLicenseMicrosheets(File xmlFile, String _name, String expDate) {
        NodeList appElements;
        LinkedHashMap<String, List<Map<String, String>>> licenseMicrosheets = new LinkedHashMap<String, List<Map<String, String>>>();
        ArrayList modulesMicrosheet = new ArrayList();
        LinkedHashMap<String, String> licentaApp = new LinkedHashMap<String, String>();
        licentaApp.put(ExportEnums.Licenta_App.data_expirare.name(), expDate);
        Document doc = LicenseManager.getXMLDocument(xmlFile);
        if (doc == null) {
            return null;
        }
        Element rootElement = doc.getDocumentElement();
        rootElement.normalize();
        String mainVersion = rootElement.getAttribute("mainVersion");
        String sequence = rootElement.getAttribute("sequence");
        licentaApp.put(ExportEnums.Licenta_App.main_version.name(), mainVersion);
        licentaApp.put(ExportEnums.Licenta_App.sequence.name(), sequence);
        licentaApp.put(ExportEnums.Licenta_App.name.name(), _name);
        NodeList elementsByTagName = doc.getElementsByTagName("systemProperty");
        if (elementsByTagName.getLength() > 0) {
            for (int i = 0; i < elementsByTagName.getLength(); ++i) {
                Node item = elementsByTagName.item(i);
                if (item.getNodeType() != 1) continue;
                Element sysProperty = (Element)item;
                String appName = sysProperty.getAttribute("name");
                String value = sysProperty.getAttribute("value");
                if (!appName.equalsIgnoreCase("hdd1SerNumber")) continue;
                if (value.equalsIgnoreCase(ANY_HDD)) {
                    try {
                        value = LicenseVerifier.getHddID();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                licentaApp.put(ExportEnums.Licenta_App.hdd_id.name(), value);
            }
        }
        if ((appElements = doc.getElementsByTagName("app")).getLength() > 0) {
            for (int i = 0; i < appElements.getLength(); ++i) {
                Node appElement = appElements.item(i);
                if (appElement.getNodeType() != 1) continue;
                Element appEl = (Element)appElement;
                String appName = appEl.getAttribute("name");
                String days = appEl.getAttribute("days");
                licentaApp.put(ExportEnums.Licenta_App.tip_aplicatie.name(), appName);
            }
        }
        licenseMicrosheets.put(ExportEnums.LicenseMicrosheet.Licenta_App.name(), Arrays.asList(licentaApp));
        NodeList nList = doc.getElementsByTagName("module");
        if (nList.getLength() > 0) {
            for (int i = 0; i < nList.getLength(); ++i) {
                String name;
                Node item = nList.item(i);
                if (item.getNodeType() != 1) continue;
                Element el = (Element)item;
                String moduleName = name = el.getAttribute("name").trim();
                String exclude = "false";
                if (name.charAt(0) == '-') {
                    moduleName = name.replaceFirst("-", "");
                    exclude = "true";
                }
                LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
                row.put(ExportEnums.Licenta_Module.nume.name(), moduleName);
                row.put(ExportEnums.Licenta_Module.exclude.name(), exclude);
                modulesMicrosheet.add(row);
            }
        }
        licenseMicrosheets.put(ExportEnums.LicenseMicrosheet.Licenta_Module.name(), modulesMicrosheet);
        return licenseMicrosheets;
    }

    private static Document getXMLDocument(File ex1) {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = null;
        Document doc = null;
        try {
            dBuilder = dbFactory.newDocumentBuilder();
            doc = dBuilder.parse(ex1);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (dBuilder == null) {
            System.out.println("ParserConfigurationException!!! Happened when tried to create new document.");
        }
        if (doc == null) {
            System.out.println("SaxException!!! Happened when tried to parse the file.");
        }
        return doc;
    }

    public static Map<String, List<Map<String, String>>> getBdMicrosheets(File xmlFile) {
        LinkedHashMap<String, List<Map<String, String>>> microsheetsMap = new LinkedHashMap<String, List<Map<String, String>>>();
        LinkedHashMap<String, String> commonAttrs = new LinkedHashMap<String, String>();
        Document doc = LicenseManager.getXMLDocument(xmlFile);
        if (doc == null) {
            return null;
        }
        Element rootElement = doc.getDocumentElement();
        rootElement.normalize();
        NodeList clientPropeties = doc.getElementsByTagName("clientProperty");
        if (clientPropeties.getLength() > 0) {
            block10: for (int i = 0; i < clientPropeties.getLength(); ++i) {
                Node item = clientPropeties.item(i);
                if (item.getNodeType() != 1) continue;
                Element el = (Element)item;
                String name = el.getAttribute("name");
                String value = el.getAttribute("value");
                switch (name) {
                    case "entityName": {
                        commonAttrs.put(ExportEnums.Licenta_Attr_Comune.brand.name(), value);
                        continue block10;
                    }
                    case "societate": {
                        commonAttrs.put(ExportEnums.Licenta_Attr_Comune.societate.name(), value);
                        continue block10;
                    }
                    case "cui": {
                        commonAttrs.put(ExportEnums.Licenta_Attr_Comune.cui.name(), value);
                        continue block10;
                    }
                }
            }
        }
        microsheetsMap.put(ExportEnums.LicenseMicrosheet.Licenta_Attr_Comune.name(), Arrays.asList(commonAttrs));
        return microsheetsMap;
    }

    private static String generateStringForChecksum(File xmlFile) {
        StringBuffer sBuilder = new StringBuffer();
        Document doc = LicenseManager.getXMLDocument(xmlFile);
        if (doc == null) {
            return null;
        }
        Element rootElement = doc.getDocumentElement();
        rootElement.normalize();
        String sequence = rootElement.getAttribute("sequence");
        sBuilder.append(sequence);
        String generatedAt = rootElement.getAttribute("generatedAt");
        sBuilder.append(generatedAt);
        LicenseManager.processInnerElements(doc, sBuilder);
        String licenseSet = sBuilder.toString();
        return ExportUtils.getLicense(licenseSet);
    }

    public static String getRootAttribute(File xmlFile, String attributeName) {
        Document doc = LicenseManager.getXMLDocument(xmlFile);
        if (doc == null) {
            return null;
        }
        Element rootElement = doc.getDocumentElement();
        rootElement.normalize();
        return rootElement.getAttribute(attributeName);
    }

    private static void processInnerElements(Document doc, StringBuffer sBuilder) {
        NodeList nList;
        NodeList appElements;
        NodeList elementsByTagName;
        NodeList clientPropeties = doc.getElementsByTagName("clientProperty");
        if (clientPropeties.getLength() > 0) {
            LicenseManager.appendValues(sBuilder, clientPropeties);
        }
        if ((elementsByTagName = doc.getElementsByTagName("systemProperty")).getLength() > 0) {
            LicenseManager.appendValues(sBuilder, elementsByTagName);
        }
        if ((appElements = doc.getElementsByTagName("app")).getLength() > 0) {
            for (int i = 0; i < appElements.getLength(); ++i) {
                Node appElement = appElements.item(i);
                if (appElement.getNodeType() != 1) continue;
                Element appEl = (Element)appElement;
                String appName = appEl.getAttribute("name");
                String days = appEl.getAttribute("days");
                sBuilder.append(appName);
                sBuilder.append(days);
            }
        }
        if ((nList = doc.getElementsByTagName("module")).getLength() > 0) {
            for (int i = 0; i < nList.getLength(); ++i) {
                Node item = nList.item(i);
                if (item.getNodeType() != 1) continue;
                Element el = (Element)item;
                String name = el.getAttribute("name");
                sBuilder.append(name);
                String days = el.getAttribute("days");
                sBuilder.append(days);
                String classname = el.getAttribute("classname");
                sBuilder.append(classname);
            }
        }
    }

    public static Boolean verifyXMLCheckSum(File xmlFile) {
        String licenseCheckSum = LicenseManager.generateStringForChecksum(xmlFile);
        String fileChecksum = LicenseManager.getRootAttribute(xmlFile, "checksum");
        if (licenseCheckSum == null) {
            return null;
        }
        if (fileChecksum == null || fileChecksum.isEmpty()) {
            return null;
        }
        if (licenseCheckSum.equals(fileChecksum)) {
            System.out.println("FISIER VALID!!!");
            return true;
        }
        System.err.println("FISIER INVALID!!!");
        return false;
    }

    private static void appendValues(StringBuffer sBuilder, NodeList elements) {
        for (int i = 0; i < elements.getLength(); ++i) {
            Node item = elements.item(i);
            if (item.getNodeType() != 1) continue;
            Element el = (Element)item;
            String name = el.getAttribute("name");
            sBuilder.append(name);
            String value = el.getAttribute("value");
            sBuilder.append(value);
        }
    }

    public static String composePcNodeTitle(File xmlFile) {
        Document doc = LicenseManager.getXMLDocument(xmlFile);
        if (doc == null) {
            return null;
        }
        Element rootElement = doc.getDocumentElement();
        rootElement.normalize();
        String pcName = rootElement.getAttribute("clientName");
        String generatedAt = rootElement.getAttribute("generatedAt");
        Date generateDate = null;
        try {
            generateDate = ExportConstants.DATE_AND_TIME_FORMAT.parse(generatedAt);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (generateDate == null) {
            System.err.println(TAG + "Formatting date :" + generatedAt + "with Formatter:" + ExportConstants.DATE_AND_TIME_FORMAT + " failed!");
            return null;
        }
        String genDate = ExportConstants.DATE_FORMAT.format(generateDate);
        return String.format("%s - %s", pcName, genDate);
    }

    static {
        licensingHash = new Hashtable();
    }
}

