/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.messaging;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.messaging.Message;
import ro.atreides.utils.messaging.db.MessengerDao;

public class Messenger {
    private static Messenger instance;
    private ConnectionPool pool = ConnectionPool.getInstance();

    private Messenger() {
    }

    public static synchronized Messenger getInstance() {
        if (instance == null) {
            instance = new Messenger();
        }
        return instance;
    }

    private synchronized MessengerDao getMessengerDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        MessengerDao dao = null;
        while (dao == null) {
            dao = (MessengerDao)this.pool.getDao(MessengerDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(MessengerDao.class.getName(), connection);
        }
        return dao;
    }

    public void addMessage(String channel, String message, long expiry) throws SQLException {
        this.getMessengerDao().addMessage(channel, message, expiry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Message> getMessages(String channel) {
        Vector<Message> result = new Vector();
        try {
            result = this.getMessengerDao().getMessagesForChannel(channel);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMessagesByChannel(String channel) {
        try {
            this.deleteMessageNoCommit(channel);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMessageById(int id) {
        try {
            this.deleteMessageByIdNoCommit(id);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void deleteMessageByIdNoCommit(int id) throws SQLException {
        this.getMessengerDao().deleteMessageById(id);
    }

    public void deleteMessageNoCommit(String channel) throws SQLException {
        this.getMessengerDao().deleteMessage(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        try {
            this.getMessengerDao().deleteAll();
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public static String codeInfosInMessageText(Map<String, String> values) {
        String result = "";
        for (String key : values.keySet()) {
            String value = values.get(key);
            result = result + key + "=" + value + "|";
        }
        if (result.length() > 0) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static Hashtable<String, String> getInfosCodedInMessageText(String text) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        Vector tokens = Utils.splitString(text, '|');
        for (String pair : tokens) {
            Vector vals = Utils.splitString(pair, '=');
            if (vals.size() <= 0) continue;
            String key = (String)vals.get(0);
            String value = "";
            if (vals.size() > 1) {
                value = (String)vals.get(1);
            }
            result.put(key, value);
        }
        return result;
    }
}

