/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.messaging.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import ro.atreides.utils.db.DaoInterface;
import ro.atreides.utils.messaging.Message;

public class MessengerDao
implements DaoInterface {
    private PreparedStatement add;
    private PreparedStatement deleteAll;
    private PreparedStatement getAllForChannel;
    private PreparedStatement deleteMessage;
    private PreparedStatement deleteMessageById;
    private Connection connection;

    public MessengerDao(Connection conn) throws SQLException {
        this.connection = conn;
        this.buildPreparedStatements();
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.deleteAll = this.connection.prepareStatement("delete from messaging");
        this.deleteMessage = this.connection.prepareStatement("delete from messaging where channel like ? ");
        this.deleteMessageById = this.connection.prepareStatement("delete from messaging where id = ? ");
        this.add = this.connection.prepareStatement("insert into messaging ( channel, text, datevalid ) values ( ?, ?, ? )");
        this.getAllForChannel = this.connection.prepareStatement("select * from messaging where channel like ? and datevalid > ? ");
    }

    public void deleteAll() throws SQLException {
        this.deleteAll.execute();
    }

    public void addMessage(String channel, String text, long expiryDate) throws SQLException {
        this.add.setString(1, channel);
        this.add.setString(2, text);
        this.add.setTimestamp(3, new Timestamp(expiryDate));
        this.add.execute();
    }

    public Vector<Message> getMessagesForChannel(String channel) throws SQLException {
        Vector<Message> result = new Vector<Message>();
        this.getAllForChannel.setString(1, channel + "%");
        this.getAllForChannel.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
        ResultSet rs = this.getAllForChannel.executeQuery();
        while (rs.next()) {
            Message m = new Message();
            m.setChannel(channel);
            m.setId(rs.getInt("id"));
            m.setText(rs.getString("text"));
            result.add(m);
        }
        rs.close();
        return result;
    }

    public void deleteMessage(String channel) throws SQLException {
        this.deleteMessage.setString(1, channel + "%");
        this.deleteMessage.execute();
    }

    public void deleteMessageById(int id) throws SQLException {
        this.deleteMessageById.setInt(1, id);
        this.deleteMessageById.execute();
    }
}

