/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.multilanguage;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.utils.Country;
import ro.atreides.utils.EventGenerator;
import ro.atreides.utils.Logger;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.multilanguage.Language;
import ro.atreides.utils.multilanguage.db.MultilangDao;

public class LanguageLogic
extends EventGenerator {
    private static LanguageLogic instance;
    private int language;
    public static String utils_events_openDayPlease;
    public static String utils_cannotContinue;
    public static String promo_reducere_procent;
    public static String promo_reducere_fixa;
    public static String promo_pret_fix;
    public static String restaurant_total_discount;
    public static String common_nedefinit;
    public static String promo_x_plus_unu;
    public static String print_nota_waiter_title;
    private ConnectionPool pool;

    private LanguageLogic() {
        try {
            this.pool = ConnectionPool.getInstance();
            this.language = 1;
            this.readMessages(this.language);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    private synchronized MultilangDao getMultilangDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        MultilangDao dao = null;
        while (dao == null) {
            dao = (MultilangDao)this.pool.getDao(MultilangDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(MultilangDao.class.getName(), connection);
        }
        return dao;
    }

    private void readMessages(int idLang) throws SQLException {
        utils_events_openDayPlease = this.getMultilangDao().getMessage("utils_events_openDayPlease", idLang);
        utils_cannotContinue = this.getMultilangDao().getMessage("utils_cannotContinue", idLang);
        promo_reducere_procent = this.getMultilangDao().getMessage("promo_reducere_procent", idLang);
        promo_reducere_fixa = this.getMultilangDao().getMessage("promo_reducere_fixa", idLang);
        promo_pret_fix = this.getMultilangDao().getMessage("promo_pret_fix", idLang);
        restaurant_total_discount = this.getMultilangDao().getMessage("restaurant_total_discount", idLang);
        common_nedefinit = this.getMultilangDao().getMessage("common_nedefinit", idLang);
        print_nota_waiter_title = this.getMultilangDao().getMessage("print_nota_waiter_title", idLang);
        promo_x_plus_unu = this.getMultilangDao().getMessage("promo_x_plus_unu", idLang);
    }

    public static synchronized LanguageLogic getInstance() {
        if (instance == null) {
            instance = new LanguageLogic();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Language getLanguageById(int id) {
        try {
            Language result;
            Language language = result = this.getMultilangDao().getLanguageById(id);
            return language;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Language language = null;
            return language;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllLanguages() {
        try {
            Collection result;
            Collection collection = result = this.getMultilangDao().getAllLanguages();
            return collection;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Collection collection = null;
            return collection;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<Integer, Country> getAllCountriesAsHash() {
        try {
            Hashtable<Integer, Country> result;
            Hashtable<Integer, Country> hashtable = result = this.getMultilangDao().getAllCountries();
            return hashtable;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Hashtable<Integer, Country> hashtable = null;
            return hashtable;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Collection<Country> getAllCountries() {
        return new Vector<Country>(this.getAllCountriesAsHash().values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCountry(String idTara, String numeTara) {
        try {
            this.getMultilangDao().addCountry(idTara, numeTara);
            this.pool.commit();
            this.notifyListeners(43);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Country getCountryById(int id) {
        try {
            Country result;
            Country country = result = this.getMultilangDao().getCountryById(id);
            return country;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Country country = null;
            return country;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Country getCountryByName(String name) {
        try {
            Country result;
            Country country = result = this.getCountryByNameNoCommit(name);
            return country;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Country country = null;
            return country;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Country getCountryByNameNoCommit(String name) throws SQLException {
        return this.getMultilangDao().getCountryByName(name);
    }
}

