/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.multilanguage.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.utils.Country;
import ro.atreides.utils.db.DaoInterface;
import ro.atreides.utils.multilanguage.Language;

public class MultilangDao
implements DaoInterface {
    private Connection connection;
    private PreparedStatement selectAllLanguages;
    private PreparedStatement selectKey;
    private PreparedStatement addKey;
    private PreparedStatement addMessage;
    private PreparedStatement selectLanguageById;
    private PreparedStatement selectAllCountries;
    private PreparedStatement selectCountryById;
    private PreparedStatement selectCountryByName;
    private PreparedStatement addCountry;
    private PreparedStatement getMessage;

    public MultilangDao(Connection connection) throws SQLException {
        this.connection = connection;
        this.buildPreparedStatements();
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.selectAllLanguages = this.connection.prepareStatement("select * from languages");
        this.selectKey = this.connection.prepareStatement("select * from keys where label = ?");
        this.addKey = this.connection.prepareStatement("insert into keys(label) values (?)");
        this.addMessage = this.connection.prepareStatement("insert into messages(id_key, id_lang, label) values (?, ?, ?)");
        this.selectLanguageById = this.connection.prepareStatement("select id, lang, lang_short from languages where id = ?");
        this.selectAllCountries = this.connection.prepareStatement("select * from tari where status = 1 order by id");
        this.selectCountryById = this.connection.prepareStatement("select * from tari where id = ? and status = 1");
        this.selectCountryByName = this.connection.prepareStatement("select * from tari where lower(nume) = ? ");
        this.addCountry = this.connection.prepareStatement("insert into tari ( idTara, nume, status ) values ( ?, ?, 1)");
        this.getMessage = this.connection.prepareStatement("select messages.label from messages inner join keys on messages.id_key = keys.id where keys.label = ? and messages.id_lang = ?");
    }

    public String getMessage(String key, int idLanguage) throws SQLException {
        String result = null;
        this.getMessage.setString(1, key);
        this.getMessage.setInt(2, idLanguage);
        ResultSet rs = this.getMessage.executeQuery();
        if (rs.next()) {
            result = rs.getString(1);
        }
        rs.close();
        return result;
    }

    public void addMessage(String label, int idKey, int idLanguage) throws SQLException {
        this.addMessage.setInt(1, idKey);
        this.addMessage.setInt(2, idLanguage);
        this.addMessage.setString(3, label);
        this.addMessage.execute();
    }

    public int getIdForKey(String key) throws SQLException {
        int result = -1;
        this.selectKey.setString(1, key);
        ResultSet rs = this.selectKey.executeQuery();
        if (rs.next()) {
            result = rs.getInt("id");
        }
        rs.close();
        return result;
    }

    public void addKey(String key) throws SQLException {
        this.addKey.setString(1, key);
        this.addKey.execute();
    }

    public Collection getAllLanguages() throws SQLException {
        Vector<Language> result = new Vector<Language>();
        ResultSet rs = this.selectAllLanguages.executeQuery();
        while (rs.next()) {
            Language l = this.getLanguageFromResultSet(rs);
            result.add(l);
        }
        rs.close();
        return result;
    }

    private Language getLanguageFromResultSet(ResultSet rs) throws SQLException {
        Language l = new Language(rs.getInt("id"), rs.getString("lang"), rs.getString("lang_short"));
        return l;
    }

    public Language getLanguageById(int id) throws SQLException {
        Language result = null;
        this.selectLanguageById.setInt(1, id);
        ResultSet rs = this.selectLanguageById.executeQuery();
        if (rs.next()) {
            result = this.getLanguageFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public Hashtable<Integer, Country> getAllCountries() throws SQLException {
        Hashtable<Integer, Country> result = new Hashtable<Integer, Country>();
        ResultSet rs = this.selectAllCountries.executeQuery();
        while (rs.next()) {
            Country c = this.getCountryFromResultSet(rs);
            result.put(c.getId(), c);
        }
        rs.close();
        return result;
    }

    public Country getCountryById(int id) throws SQLException {
        Country result = null;
        this.selectCountryById.setInt(1, id);
        ResultSet rs = this.selectCountryById.executeQuery();
        if (rs.next()) {
            result = this.getCountryFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public Country getCountryByName(String nume) throws SQLException {
        Country result = null;
        this.selectCountryByName.setString(1, nume.toLowerCase());
        ResultSet rs = this.selectCountryByName.executeQuery();
        if (rs.next()) {
            result = this.getCountryFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    private Country getCountryFromResultSet(ResultSet rs) throws SQLException {
        Country c = new Country(rs.getInt("id"), rs.getString("nume"), rs.getString("idTara"), rs.getString("steag_path"));
        return c;
    }

    public void addCountry(String idCountry, String name) throws SQLException {
        this.addCountry.setString(1, idCountry);
        this.addCountry.setString(2, name);
        this.addCountry.execute();
    }
}

