/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.myUtils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.print.PrinterJob;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.RepaintManager;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class SwingPrintUtilities {
    public static void print(Component c) {
        SwingPrintUtilities.printPNGImage(SwingPrintUtilities.getBytesFromImage(SwingPrintUtilities.getImage(c)));
    }

    public static void print(Component c, double percWidth, double percHeight) {
        SwingPrintUtilities.printPNGImage(SwingPrintUtilities.getBytesFromImage(SwingPrintUtilities.scaleImage(SwingPrintUtilities.getImage(c), percWidth, percHeight)));
    }

    public static void print(Component c, Rectangle rect) {
        SwingPrintUtilities.printPNGImage(SwingPrintUtilities.getBytesFromImage(SwingPrintUtilities.getSubImage(SwingPrintUtilities.getImage(c), rect)));
    }

    public static void print(Component c, Rectangle rect, double percWidth, double percHeight) {
        BufferedImage copy = SwingPrintUtilities.copyImage(SwingPrintUtilities.getSubImage(SwingPrintUtilities.getImage(c), rect));
        SwingPrintUtilities.printPNGImage(SwingPrintUtilities.getBytesFromImage(SwingPrintUtilities.scaleImage(copy, percWidth, percHeight)));
    }

    public static void print(JTree tree, TreePath parent) {
        if (parent == null) {
            SwingPrintUtilities.print(tree);
            return;
        }
        DefaultMutableTreeNode rootTableNode = (DefaultMutableTreeNode)parent.getLastPathComponent();
        if (tree.getModel().getRoot() == rootTableNode) {
            SwingPrintUtilities.print(tree);
        } else {
            SwingPrintUtilities.print((Component)tree, SwingPrintUtilities.getRectangleForNodes(tree, parent));
        }
    }

    public static void print(JTree tree, TreePath parent, double percWidth, double percHeight) {
        DefaultMutableTreeNode rootTableNode = (DefaultMutableTreeNode)parent.getLastPathComponent();
        if (tree.getModel().getRoot() == rootTableNode) {
            SwingPrintUtilities.print(tree, percWidth, percHeight);
        } else {
            SwingPrintUtilities.print((Component)tree, SwingPrintUtilities.getRectangleForNodes(tree, parent), percWidth, percHeight);
        }
    }

    public static void printPreview(Component c, double percWidth, double percHeight) {
        BufferedImage img = SwingPrintUtilities.getImage(c);
        img = SwingPrintUtilities.scaleImage(img, percWidth, percHeight);
        SwingPrintUtilities.printPreview(img);
    }

    public static void printPreview(Component c) {
        SwingPrintUtilities.printPreview(SwingPrintUtilities.getImage(c));
    }

    public static void printPreview(JTree tree, TreePath parent) {
        SwingPrintUtilities.printPreview(SwingPrintUtilities.getSubImage(SwingPrintUtilities.getImage(tree), SwingPrintUtilities.getRectangleForNodes(tree, parent)));
    }

    public static void printPreview(JTree tree, TreePath parent, double percWidth, double percHeight) {
        BufferedImage copy = SwingPrintUtilities.copyImage(SwingPrintUtilities.getSubImage(SwingPrintUtilities.getImage(tree), SwingPrintUtilities.getRectangleForNodes(tree, parent)));
        SwingPrintUtilities.printPreview(SwingPrintUtilities.scaleImage(copy, percWidth, percHeight));
    }

    public static void printPreview(final BufferedImage image) {
        ImagePanel imp = new ImagePanel(image);
        final JComboBox<PrintService> combo = new JComboBox<PrintService>(SwingPrintUtilities.getPrintServices());
        combo.setEditable(false);
        final JFrame frame = new JFrame("Print Preview");
        frame.setDefaultCloseOperation(2);
        frame.setLayout(new GridBagLayout());
        JButton print = new JButton("<html><font color=green>Print</font></html>");
        print.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintService ps = (PrintService)combo.getSelectedItem();
                if (ps != null) {
                    SwingPrintUtilities.printPNGImage(SwingPrintUtilities.getBytesFromImage(image), ps);
                }
                frame.dispose();
            }
        });
        JPanel printPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(4, 4, 4, 4);
        c.gridx = 0;
        c.gridy = 0;
        printPanel.add((Component)new JLabel("<html>Printer</html>"), c);
        ++c.gridx;
        c.weightx = 1.0;
        printPanel.add(combo, c);
        ++c.gridx;
        c.weightx = 0.0;
        printPanel.add((Component)print, c);
        printPanel.add((Component)print, c);
        c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 1;
        c.anchor = 10;
        c.gridx = 0;
        c.gridy = 0;
        frame.add((Component)printPanel, c);
        ++c.gridy;
        c.weighty = 1.0;
        frame.add((Component)new JScrollPane(imp), c);
        frame.setSize(600, 800);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public static void printPNGImage(String filename) {
        System.out.println("printPNGImage, INPUT_STREAM");
        try {
            HashPrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
            pras.add(new Copies(1));
            PrintService ps = PrintServiceLookup.lookupDefaultPrintService();
            System.out.println("Printing to " + ps);
            DocPrintJob job = ps.createPrintJob();
            FileInputStream fin = new FileInputStream(filename);
            SimpleDoc doc = new SimpleDoc(fin, DocFlavor.INPUT_STREAM.PNG, null);
            job.print(doc, pras);
            fin.close();
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        catch (PrintException pe) {
            pe.printStackTrace();
        }
    }

    public static void printPNGImage(byte[] imageBytes) {
        System.out.println("printPNGImage, BYTE_ARRAY");
        try {
            HashPrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
            PrintService ps = PrintServiceLookup.lookupDefaultPrintService();
            System.out.println("Printing to " + ps);
            DocPrintJob job = ps.createPrintJob();
            SimpleDoc doc = new SimpleDoc(imageBytes, DocFlavor.BYTE_ARRAY.PNG, null);
            job.print(doc, pras);
        }
        catch (PrintException pe) {
            pe.printStackTrace();
        }
    }

    public static void printPNGImage(byte[] imageBytes, PrintService ps) {
        System.out.println("printPNGImage, BYTE_ARRAY");
        try {
            HashPrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
            System.out.println("Printing to " + ps);
            DocPrintJob job = ps.createPrintJob();
            SimpleDoc doc = new SimpleDoc(imageBytes, DocFlavor.BYTE_ARRAY.PNG, null);
            job.print(doc, pras);
        }
        catch (PrintException pe) {
            pe.printStackTrace();
        }
    }

    public static BufferedImage getImage(Component source) {
        BufferedImage image = SwingPrintUtilities.makeImage(source.getWidth(), source.getHeight());
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        RepaintManager currentManager = RepaintManager.currentManager(source);
        currentManager.setDoubleBufferingEnabled(false);
        source.paint(g2);
        currentManager.setDoubleBufferingEnabled(true);
        return image;
    }

    public static BufferedImage makeImage(int width, int height) {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(width, height);
    }

    public static byte[] getBytesFromImage(BufferedImage image) {
        byte[] resultImageAsRawBytes = null;
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream(0x200000);
        try {
            ImageIO.write((RenderedImage)image, "png", arrayOutputStream);
            arrayOutputStream.flush();
            resultImageAsRawBytes = arrayOutputStream.toByteArray();
            arrayOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resultImageAsRawBytes;
    }

    public static BufferedImage scaleImage(BufferedImage image, double percentWidth, double persentHeight) {
        int scaledW = (int)((double)image.getWidth() * percentWidth);
        int scaledH = (int)((double)image.getHeight() * persentHeight);
        BufferedImage newImage = SwingPrintUtilities.makeImage(scaledW, scaledH);
        Graphics2D g2 = (Graphics2D)newImage.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        SwingPrintUtilities.drawImage(g2, image, 0, 0, scaledW, scaledH, null);
        return newImage;
    }

    public static BufferedImage copyImage(BufferedImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        BufferedImage copy = SwingPrintUtilities.makeImage(w, h);
        SwingPrintUtilities.drawImage((Graphics2D)copy.getGraphics(), image, 0, 0, w, h, null);
        return copy;
    }

    public static void drawImage(Graphics2D g2, BufferedImage image, int x, int y, int w, int h, ImageObserver observer) {
        g2.drawImage(image, x, y, w, h, observer);
        g2.dispose();
    }

    public static BufferedImage getSubImage(BufferedImage image, Rectangle rect) {
        return image.getSubimage(rect.x, rect.y, rect.width, rect.height);
    }

    public static void writePNGImage(BufferedImage image, String filename) {
        SwingPrintUtilities.writeImage(image, filename, "png");
    }

    public static void writeImage(BufferedImage image, String filename, String format) {
        try {
            ImageIO.write((RenderedImage)image, format, new File(filename));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeImage(Component c, double percWidth, double percHeight, String filename, String extension) {
        BufferedImage img = SwingPrintUtilities.getImage(c);
        img = SwingPrintUtilities.scaleImage(img, percWidth, percHeight);
        SwingPrintUtilities.writeImage(img, filename, extension);
    }

    private static Rectangle getRectangleForNodes(JTree tree, TreePath parent) {
        Rectangle rectangle;
        if (parent == null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getModel().getRoot();
            if (node == null) {
                return new Rectangle(tree.getSize());
            }
            parent = new TreePath(node.getPath());
        }
        if ((rectangle = tree.getPathBounds(parent)) != null) {
            SwingPrintUtilities.getRectangleForNodes(tree, parent, rectangle);
        }
        return rectangle;
    }

    private static void getRectangleForNodes(JTree tree, TreePath parent, Rectangle maxRectangle) {
        Rectangle rectangle;
        DefaultMutableTreeNode rootTableNode = (DefaultMutableTreeNode)parent.getLastPathComponent();
        if (!rootTableNode.isLeaf()) {
            int children = rootTableNode.getChildCount();
            for (int i = 0; i < children; ++i) {
                TreePath path = parent.pathByAddingChild(rootTableNode.getChildAt(i));
                Rectangle rectangle2 = tree.getPathBounds(path);
                if (rectangle2 == null) continue;
                maxRectangle.width = Math.max(maxRectangle.width, rectangle2.x - maxRectangle.x + rectangle2.width);
                maxRectangle.height = Math.max(maxRectangle.height, rectangle2.y - maxRectangle.y + rectangle2.height);
                SwingPrintUtilities.getRectangleForNodes(tree, path, maxRectangle);
            }
        }
        if ((rectangle = tree.getPathBounds(parent)) != null) {
            maxRectangle.width = Math.max(maxRectangle.width, rectangle.x - maxRectangle.x + rectangle.width);
            maxRectangle.height = Math.max(maxRectangle.height, rectangle.y - maxRectangle.y + rectangle.height);
        }
    }

    protected static PrintService[] getPrintServices() {
        return PrinterJob.lookupPrintServices();
    }

    static class ImagePanel
    extends JPanel {
        private Image img;
        private Dimension imageSize;

        public ImagePanel(String img) {
            this(new ImageIcon(img).getImage());
        }

        public ImagePanel(Image img) {
            this.img = img;
            Dimension size = this.imageSize = new Dimension(img.getWidth(null), img.getHeight(null));
            this.setPreferredSize(size);
            this.setMinimumSize(size);
            this.setMaximumSize(size);
            this.setSize(size);
            this.setLayout(null);
            this.setBorder(new LineBorder(Color.black));
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.drawImage(this.img, 0, 0, null);
            g.setColor(Color.RED);
            g.drawRect(0, 0, this.imageSize.width, this.imageSize.height);
        }
    }
}

