/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.plati;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumnModel;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.TipCont;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.plati.ConturiInterface;
import ro.atreides.utils.plati.PromotionsInterface;
import ro.atreides.utils.plati.SimplePromotion;
import ro.atreides.utils.plati.TipPlata;
import ro.atreides.utils.plati.TipPlataProvider;

public class TipPlataPanel
extends AbstractListPanel {
    private JTextField mpText;
    private JTextField codText;
    private TipPlata editableTipPlata;
    private JCheckBox implicit;
    private JCheckBox detalii;
    private JCheckBox parola;
    private JCheckBox documentDePlata;
    private JComboBox tipCont;
    private JComboBox promotii;
    private PromotionsInterface promoInterface;
    private ConturiInterface conturiInterface;
    protected boolean showTipCont = true;
    protected boolean showPromotie = true;

    public TipPlataPanel() {
    }

    public TipPlataPanel(boolean showTipCont, boolean showPromotie) {
        this.showTipCont = showTipCont;
        this.showPromotie = showPromotie;
    }

    public void setConturiInterface(ConturiInterface conturiInterface) {
        this.conturiInterface = conturiInterface;
    }

    public void setPromoInterface(PromotionsInterface promoInterface) {
        this.promoInterface = promoInterface;
    }

    @Override
    public String[] buildColumns() {
        return new String[]{LangRoAll.denumireTipPlata, LangRoAll.codCasaMarcat, LangRoAll.implicit, LangRoAll.tipCont, LangRoAll.promotie, LangRoAll.cereDetalii, LangRoAll.cereParola, "Document de plata"};
    }

    @Override
    public Vector buildData() {
        return TipPlataProvider.getInstance().getTipPlata();
    }

    @Override
    public Class[] buildTypes() {
        return new Class[]{String.class, String.class, Boolean.class, String.class, String.class, Boolean.class, Boolean.class, Boolean.class};
    }

    @Override
    public JPanel getBottomPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 0;
        c.weightx = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 0, 2, 0);
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.denumireTipPlata), c);
        ++c.gridx;
        this.mpText = new JTextField(7);
        result.add((Component)this.mpText, c);
        ++c.gridx;
        result.add((Component)new JLabel(LangRoAll.codCasaMarcat), c);
        ++c.gridx;
        this.codText = new JTextField(3);
        result.add((Component)this.codText, c);
        ++c.gridx;
        result.add((Component)new JLabel(LangRoAll.implicit), c);
        ++c.gridx;
        this.implicit = new JCheckBox();
        this.implicit.setSelected(false);
        result.add((Component)this.implicit, c);
        ++c.gridx;
        result.add((Component)new JLabel(LangRoAll.cereParola), c);
        ++c.gridx;
        this.parola = new JCheckBox();
        this.parola.setSelected(false);
        result.add((Component)this.parola, c);
        ++c.gridx;
        result.add((Component)new JLabel("Document de plata"), c);
        ++c.gridx;
        this.documentDePlata = new JCheckBox();
        this.documentDePlata.setSelected(false);
        result.add((Component)this.documentDePlata, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.cereDetalii), c);
        ++c.gridx;
        this.detalii = new JCheckBox();
        this.detalii.setSelected(false);
        result.add((Component)this.detalii, c);
        Vector conturi = this.conturiInterface.getAllConturi();
        this.tipCont = ComboUtils.buildComboWithAll(conturi);
        if (this.showTipCont) {
            ++c.gridx;
            result.add((Component)new JLabel(LangRoAll.tipCont), c);
            ++c.gridx;
            result.add((Component)this.tipCont, c);
        }
        this.promotii = new JComboBox();
        this.rebuildPromotions();
        if (this.showPromotie) {
            ++c.gridx;
            result.add((Component)new JLabel(LangRoAll.promotie), c);
            ++c.gridx;
            result.add((Component)this.promotii, c);
        }
        final TipPlataPanel parent = this;
        ++c.gridx;
        JButton salveaza = new JButton(LangRoAll.salveaza);
        salveaza.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String toAdd = TipPlataPanel.this.mpText.getText();
                String cod = TipPlataPanel.this.codText.getText();
                int idPromo = -1;
                if (ComboUtils.anythingButAllSelected(TipPlataPanel.this.promotii)) {
                    SimplePromotion sp = (SimplePromotion)TipPlataPanel.this.promotii.getSelectedItem();
                    idPromo = sp.getId();
                }
                int idCont = -1;
                if (ComboUtils.anythingButAllSelected(TipPlataPanel.this.tipCont)) {
                    TipCont cont = (TipCont)TipPlataPanel.this.tipCont.getSelectedItem();
                    idCont = cont.getId();
                }
                if (!Validators.correctString(cod) && !DialogUtils.confirmDialog(parent, "Cod Casa marcat necompletat! Nu veti putea tipari bonuri fiscale cu acest tip de plata!! Continuam", LangRoAll.atentie)) {
                    TipPlataPanel.this.codText.requestFocus();
                    return;
                }
                if (Validators.correctString(toAdd)) {
                    if (TipPlataPanel.this.editableTipPlata == null) {
                        boolean isDefault = false;
                        if (TipPlataPanel.this.tm.getData().size() == 0) {
                            isDefault = true;
                        }
                        TipPlataProvider.getInstance().addTipPlata(toAdd, cod, isDefault, idCont, idPromo, TipPlataPanel.this.detalii.isSelected(), TipPlataPanel.this.parola.isSelected(), TipPlataPanel.this.documentDePlata.isSelected());
                    } else {
                        TipPlataPanel.this.editableTipPlata.setEcrMapping(cod);
                        TipPlataPanel.this.editableTipPlata.setLabel(toAdd);
                        TipPlataPanel.this.editableTipPlata.setDefault(TipPlataPanel.this.implicit.isSelected());
                        TipPlataPanel.this.editableTipPlata.setIdTipCont(idCont);
                        TipPlataPanel.this.editableTipPlata.setIdPromo(idPromo);
                        TipPlataPanel.this.editableTipPlata.setRequestComment(TipPlataPanel.this.detalii.isSelected());
                        TipPlataPanel.this.editableTipPlata.setRequestPassword(TipPlataPanel.this.parola.isSelected());
                        TipPlataPanel.this.editableTipPlata.setDocumentDePlata(TipPlataPanel.this.documentDePlata.isSelected());
                        TipPlataProvider.getInstance().updateTipPlata(TipPlataPanel.this.editableTipPlata);
                    }
                    TipPlataPanel.this.refreshTable();
                    TipPlataPanel.this.setTipPlata(null);
                    TipPlataPanel.this.mpText.requestFocus();
                } else {
                    DialogUtils.errorDialog(parent, LangRoAll.completatiDenumireaTipPlata, LangRoAll.nuPotContinua);
                }
            }
        });
        result.add((Component)salveaza, c);
        ++c.gridx;
        JButton sterge = new JButton(LangRoAll.sterge);
        sterge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogUtils.confirmDialog(parent, LangRoAll.stergemTipulDePlata, LangRoAll.confirmare)) {
                    TipPlataProvider.getInstance().deleteTipPlata(TipPlataPanel.this.editableTipPlata.getId());
                }
                TipPlataPanel.this.refreshTable();
                TipPlataPanel.this.setTipPlata(null);
                TipPlataPanel.this.mpText.requestFocus();
            }
        });
        result.add((Component)sterge, c);
        result.setBorder(new TitledBorder(LangRoAll.actiuni));
        return result;
    }

    private void rebuildPromotions() {
        Vector p = this.promoInterface.getPromotions();
        ComboUtils.replaceItemsForCombo(this.promotii, p);
    }

    public void setTipPlata(TipPlata tip) {
        String nume = "";
        String cod = "";
        boolean isDefault = false;
        boolean requestComments = false;
        boolean requestParola = false;
        boolean doc = false;
        if (tip != null) {
            nume = tip.getLabel();
            cod = tip.getEcrMapping();
            isDefault = tip.isDefault();
            requestComments = tip.isRequestComment();
            requestParola = tip.isRequestPassword();
            doc = tip.isDocumentDePlata();
            int idPromo = tip.getIdPromo();
            if (idPromo != -1) {
                SimplePromotion sp = this.promoInterface.getPromotionById(idPromo);
                this.promotii.setSelectedItem(sp);
            } else {
                this.promotii.setSelectedIndex(0);
            }
            int idTip = tip.getIdTipCont();
            if (idTip != -1) {
                TipCont c = this.conturiInterface.getContById(idTip);
                this.tipCont.setSelectedItem(c);
            } else {
                this.tipCont.setSelectedIndex(0);
            }
        }
        this.mpText.setText(nume);
        this.codText.setText(cod);
        this.implicit.setSelected(isDefault);
        this.detalii.setSelected(requestComments);
        this.parola.setSelected(requestParola);
        this.documentDePlata.setSelected(doc);
        this.editableTipPlata = tip;
    }

    @Override
    public AbstractTM buildTableModel() {
        return new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                TipPlata plata = (TipPlata)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return plata.getLabel();
                    }
                    case 1: {
                        return plata.getEcrMapping();
                    }
                    case 2: {
                        return new Boolean(plata.isDefault());
                    }
                    case 3: {
                        TipCont t = TipPlataPanel.this.conturiInterface.getContById(plata.getIdTipCont());
                        if (t != null) {
                            return t.getLabel();
                        }
                        return "";
                    }
                    case 4: {
                        SimplePromotion sp = TipPlataPanel.this.promoInterface.getPromotionById(plata.getIdPromo());
                        if (sp != null) {
                            return sp.getLabel();
                        }
                        return "";
                    }
                    case 5: {
                        return new Boolean(plata.isRequestComment());
                    }
                    case 6: {
                        return new Boolean(plata.isRequestPassword());
                    }
                    case 7: {
                        return new Boolean(plata.isDocumentDePlata());
                    }
                }
                return null;
            }
        });
    }

    @Override
    public void doStuff() {
        this.display();
        this.promoInterface.addListener(new EventListener(){

            @Override
            public void dataChanged() {
                TipPlataPanel.this.rebuildPromotions();
            }

            @Override
            public String getName() {
                return LangRoAll.tipPlataPromotionsChanged;
            }
        }, 8);
        TableColumnModel colModel = this.table.getColumnModel();
        if (!this.showPromotie) {
            colModel.getColumn(4).setMaxWidth(0);
        }
        if (!this.showTipCont) {
            colModel.getColumn(3).setMaxWidth(0);
        }
    }
}

