/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.plati;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.plati.Plata;
import ro.atreides.utils.plati.PlatiOperationsInterface;
import ro.atreides.utils.plati.TipPlata;
import ro.atreides.utils.plati.TipPlataButtonPushed;
import ro.atreides.utils.plati.db.TipPlataDao;

public class TipPlataProvider {
    private JButton[] buttons;
    private static TipPlataProvider instance = null;
    private Hashtable platiLabel = new Hashtable();
    private JLabel restText = new JLabel();
    private ConnectionPool pool = ConnectionPool.getInstance();

    private TipPlataProvider() {
    }

    public static synchronized TipPlataProvider getInstance() {
        if (instance == null) {
            instance = new TipPlataProvider();
        }
        return instance;
    }

    private synchronized TipPlataDao getTipPlataDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        TipPlataDao dao = null;
        while (dao == null) {
            dao = (TipPlataDao)this.pool.getDao(TipPlataDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(TipPlataDao.class.getName(), connection);
        }
        return dao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TipPlata getTipPlataByNameCommit(String name) {
        try {
            TipPlata result;
            TipPlata tipPlata2 = result = this.getTipPlataByNameNoCommit(name);
            return tipPlata2;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            TipPlata tipPlata3 = null;
            return tipPlata3;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public TipPlata getTipPlataByNameNoCommit(String name) throws SQLException {
        return this.getTipPlataDao().getByName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TipPlata getTipPlataByCodCasa(String codCasa) {
        try {
            TipPlata result;
            TipPlata tipPlata2 = result = this.getTipPlataDao().getByCodCasa(codCasa);
            return tipPlata2;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            TipPlata tipPlata3 = null;
            return tipPlata3;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TipPlata getTipPlataById(int id) {
        try {
            TipPlata result = this.getTipPlataByIdNoCommit(id);
            this.pool.commit();
            TipPlata tipPlata2 = result;
            return tipPlata2;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            TipPlata tipPlata3 = null;
            return tipPlata3;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public TipPlata getTipPlataByIdNoCommit(int id) throws SQLException {
        return this.getTipPlataDao().getById(id);
    }

    public Vector<TipPlata> getTipPlataNoCommit() throws SQLException {
        Vector<TipPlata> result = this.getTipPlataDao().getAllTipPlata();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<TipPlata> getTipPlata() {
        try {
            Vector<TipPlata> result = this.getTipPlataNoCommit();
            this.pool.commit();
            Vector<TipPlata> vector = result;
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<TipPlata> vector = new Vector<TipPlata>();
            return vector;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTipPlata(String label, String codCasa, boolean isDefault, int tipCont, int promo, boolean requestComment, boolean requestPassword, boolean documentDePlata) {
        try {
            this.getTipPlataDao().addTipPlata(label, codCasa, isDefault, tipCont, promo, requestComment, requestPassword, documentDePlata);
            this.pool.requestConnection().commitTransaction();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTipPlata(TipPlata tip) {
        try {
            this.getTipPlataDao().updateTipPlata(tip.getLabel(), tip.getEcrMapping(), tip.isDefault(), tip.getIdTipCont(), tip.getIdPromo(), tip.isRequestComment(), tip.isRequestPassword(), tip.isDocumentDePlata(), tip.getId());
            if (tip.isDefault()) {
                this.getTipPlataDao().clearDefault();
                this.getTipPlataDao().setDefault(tip.getId());
            }
            this.pool.requestConnection().commitTransaction();
        }
        catch (SQLException e) {
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            Logger.logException(this, (Exception)e);
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTipPlata(int idTipPlata) {
        try {
            this.getTipPlataDao().deleteTipPlata(idTipPlata);
            this.pool.requestConnection().commitTransaction();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TipPlata getDefaultTipPlataCommit() {
        try {
            TipPlata result;
            TipPlata tipPlata2 = result = this.getTipPlataDao().getDefaultTipPlata();
            return tipPlata2;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            TipPlata tipPlata3 = null;
            return tipPlata3;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public TipPlata getDefaultTipPlataNoCommit() throws SQLException {
        return this.getTipPlataDao().getDefaultTipPlata();
    }

    public JPanel buildPlatiPanel(final JComponent parent, final PlatiOperationsInterface opInterface) {
        return this.buildPlatiPanel(parent, opInterface, new TipPlataButtonPushed(){

            @Override
            public void startEditSuma(TipPlata tipPlata2) {
                if (!opInterface.canRunOperations()) {
                    return;
                }
                int clientIndex = opInterface.getClientIndex();
                double suma = opInterface.getSumaForPlata(tipPlata2.getId(), clientIndex);
                String value = DialogUtils.inputDialog(parent, Utils.getString2Decimals(suma), "Introduceti suma");
                try {
                    suma = Utils.parseDouble(value);
                    if (suma < 0.0) {
                        suma = 0.0;
                    }
                    String comentarii = "";
                    if (suma > 0.0 && tipPlata2.isRequestComment() && !Validators.correctString(comentarii = DialogUtils.inputDialog(parent, "", "Introduceti detalii"))) {
                        comentarii = "";
                    }
                    Plata plata = new Plata(tipPlata2.getId(), suma, tipPlata2.getEcrMapping(), tipPlata2.getLabel(), comentarii, clientIndex);
                    opInterface.addPlata(plata);
                }
                catch (NumberFormatException e1) {
                    return;
                }
            }
        });
    }

    public JPanel buildPlatiPanel(JComponent parent, PlatiOperationsInterface opInterface, TipPlataButtonPushed btnInterface) {
        return this.buildPlatiPanel(parent, opInterface, btnInterface, true, 1);
    }

    private JPanel buildPlatiPanel(JComponent parent, PlatiOperationsInterface opInterface, final TipPlataButtonPushed btnInterface, boolean showLabels, int insets) {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        Vector<TipPlata> _vTipPlata = TipPlataProvider.getInstance().getTipPlata();
        Vector<TipPlata> allowedTipPlata = new Vector<TipPlata>();
        for (TipPlata tipPlata2 : _vTipPlata) {
            if (!opInterface.filterTipPlata(tipPlata2)) continue;
            allowedTipPlata.add(tipPlata2);
        }
        this.buttons = new JButton[allowedTipPlata.size()];
        if (allowedTipPlata.size() > 0) {
            ++c.gridx;
            if (showLabels) {
                result.add((Component)new JLabel("din care: "), c);
            }
            int i = 0;
            Iterator iter = allowedTipPlata.iterator();
            while (iter.hasNext()) {
                ++c.gridx;
                final TipPlata tipPlata3 = (TipPlata)iter.next();
                JLabel _plata = new JLabel();
                _plata.setText("");
                if (showLabels) {
                    result.add((Component)_plata, c);
                }
                ++c.gridx;
                JButton modPlata = new JButton(tipPlata3.getLabel());
                Font font = new Font(null, 0, Config.getInstance().getInt("touch2TipPlataFontSize", 10));
                modPlata.setFont(font);
                modPlata.setFocusable(false);
                modPlata.setMargin(new Insets(insets, insets, insets, insets));
                this.buttons[i] = modPlata;
                this.platiLabel.put(new Integer(tipPlata3.getId()), _plata);
                modPlata.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        btnInterface.startEditSuma(tipPlata3);
                    }
                });
                result.add((Component)modPlata, c);
                ++i;
            }
            ++c.gridx;
            if (showLabels) {
                result.add((Component)new JLabel("Rest"), c);
            }
            ++c.gridx;
            this.restText = new JLabel("");
            if (showLabels) {
                result.add((Component)this.restText, c);
            }
        }
        return result;
    }

    public void pushButton(int index) {
        if (index < this.buttons.length) {
            this.buttons[index].doClick();
        }
    }

    public void updatePlatiLabels(Vector<Plata> plati, PlatiOperationsInterface op) {
        JLabel label;
        double platit = 0.0;
        for (Integer idPlata : this.platiLabel.keySet()) {
            label = (JLabel)this.platiLabel.get(idPlata);
            label.setText("");
        }
        for (Plata plata : plati) {
            label = (JLabel)this.platiLabel.get(plata.getIdTipPlata());
            String s = label.getText();
            if (Validators.correctDouble(s)) {
                double totalPartial = Utils.parseDouble(s);
                label.setText(Utils.getString2Decimals(totalPartial += plata.getSuma()));
            } else {
                label.setText(Utils.getString2Decimals(plata.getSuma()));
            }
            platit += plata.getSuma();
        }
        double rest = platit - op.getTotal();
        this.restText.setText(Utils.getString2Decimals(rest));
    }

    public void setRestText1(String s) {
        this.restText.setText(s);
    }

    public void cleanPlatiLabel1() {
        for (JLabel label : this.platiLabel.values()) {
            label.setText("");
        }
        this.restText.setText("");
    }
}

