/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.plati.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.plati.PlataListener;
import ro.atreides.utils.plati.TipPlata;

public class PlataPanel
extends JPanel {
    private PlataListener listener;

    public PlataPanel(PlataListener listener) {
        this.listener = listener;
        this.display();
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weighty = 1.0;
        c.fill = 2;
        c.anchor = 11;
        final JTextField detalii = new JTextField(15);
        final JTextField total = new JTextField(15);
        final JComboBox combo = new JComboBox(this.listener.getTipPlata());
        JButton adauga = new JButton(LangRoAll.adauga);
        adauga.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TipPlata tip = (TipPlata)combo.getSelectedItem();
                int tipInt = tip.getId();
                String detaliiS = detalii.getText();
                double amount = 0.0;
                String totalS = total.getText();
                if (!Validators.correctDouble(totalS)) {
                    total.setText("");
                    return;
                }
                amount = Utils.parseDouble(totalS);
                boolean detaliiOK = PlataPanel.this.listener.verificaDetalii(tip.getLabel(), detaliiS);
                if (!detaliiOK) {
                    detalii.setText("");
                    return;
                }
                PlataPanel.this.listener.plataAdded(amount, tipInt, detaliiS);
                detalii.setText("");
                total.setText("");
            }
        });
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)new JLabel("Tip plata"), c);
        ++c.gridx;
        this.add(combo, c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel(LangRoAll.suma), c);
        ++c.gridx;
        this.add((Component)total, c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel(LangRoAll.detalii), c);
        ++c.gridx;
        this.add((Component)detalii, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.fill = 0;
        this.add((Component)adauga, c);
        this.setBorder(new TitledBorder("Plata"));
    }
}

