/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.plati.gui;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Utils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.plati.PlataClinica;
import ro.atreides.utils.plati.PlataEntry;
import ro.atreides.utils.plati.TipPlataProvider;

public class PlataTM
extends AbstractTableModel {
    public static final String[] columns = new String[]{LangRoAll.modPlata, LangRoAll.suma, LangRoAll.detalii, "Data si ora"};
    private Vector data;
    private TipPlataProvider logic;

    public PlataTM(Vector data, TipPlataProvider logic) {
        this.logic = logic;
        this.setData(data);
    }

    public void refresh(Vector newData) {
        this.setData(newData);
        this.fireTableDataChanged();
    }

    private void setData(Vector newData) {
        if (newData != null) {
            this.data = new Vector();
            for (PlataClinica element : newData) {
                String tip = this.logic.getTipPlataById(element.getIdTipPlata()).getLabel();
                PlataEntry pe = new PlataEntry(element.getId(), tip, element.getSuma(), Formatters.DATE_AND_TIME_FORMAT.format(element.getDataIncasare()), element.getDetalii());
                this.data.add(pe);
            }
        } else {
            this.data = new Vector();
        }
    }

    @Override
    public int getColumnCount() {
        return columns.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex > this.data.size() || rowIndex < 0 || columnIndex < 0 || columnIndex >= columns.length) {
            return null;
        }
        PlataEntry entry = (PlataEntry)this.data.elementAt(rowIndex);
        switch (columnIndex) {
            case 0: {
                return entry.getTipPlata();
            }
            case 1: {
                return Utils.getString2Decimals(entry.getSuma());
            }
            case 3: {
                return entry.getData();
            }
            case 2: {
                return entry.getDetalii();
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        return columns[column];
    }

    public PlataEntry getAt(int rowIndex) {
        if (rowIndex > this.data.size() || rowIndex < 0) {
            return null;
        }
        return (PlataEntry)this.data.elementAt(rowIndex);
    }

    public double getTotal() {
        double result = 0.0;
        for (PlataEntry element : this.data) {
            result += element.getSuma();
        }
        return result;
    }
}

