/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.plati.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import ro.atreides.utils.plati.PlataDeleted;
import ro.atreides.utils.plati.PlataEntry;
import ro.atreides.utils.plati.TipPlataProvider;
import ro.atreides.utils.plati.gui.PlataTM;

public class PlatiTable
extends JPanel {
    private PlataTM plataTM;
    private TipPlataProvider logic;
    private PlataDeleted listener;

    public PlatiTable(TipPlataProvider logic, PlataDeleted listener) {
        this.logic = logic;
        this.listener = listener;
        this.display();
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 1;
        c.anchor = 10;
        this.plataTM = new PlataTM(null, this.logic);
        final JTable plataTable = new JTable(this.plataTM);
        plataTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow = plataTable.rowAtPoint(e.getPoint());
                if (selRow != -1 && e.getClickCount() == 2) {
                    PlataEntry pe = PlatiTable.this.plataTM.getAt(selRow);
                    PlatiTable.this.listener.plataDeleted(pe.getIdPlata());
                    PlatiTable.this.listener.afterPlataDeleted();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        JScrollPane scroll1 = new JScrollPane(plataTable);
        this.add((Component)scroll1, c);
        this.setBorder(new TitledBorder("Plati"));
    }

    public void refreshPlati(Vector newPlati) {
        this.plataTM.refresh(newPlati);
    }
}

