/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.reports;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.TimedPermissionsInterface;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.gui.DateSelector;
import ro.atreides.utils.gui.DateSelectorInterface;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.FileDialog;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.SortComparatorProvider;
import ro.atreides.utils.gui.table.SortableTable;
import ro.atreides.utils.multilang.LangRoAll;

public abstract class AbstractReportPanel
extends ReflectedJPanel
implements SortComparatorProvider {
    protected Hashtable criteria = new Hashtable();
    protected Vector data;
    protected DateSelectorInterface dateSelector;
    private JButton raport;
    private JButton print;
    private JButton excel;
    private JButton preview;
    private JButton xml;
    private JButton dbf;
    protected SortableTable table;
    protected AbstractTM tm;
    protected JPanel totalPanel;
    protected JPanel customParamsPanel;
    private long lastRefresh;
    private Thread refreshThread;
    private boolean refreshThreadRunning;
    private TimedPermissionsInterface timedPermissions;
    private JScrollPane scroll;

    public AbstractReportPanel() {
        this.init();
        this.display();
    }

    protected void replaceTableModel() {
        this.tm = this.buildTableModel();
        this.table = new SortableTable(this.tm, this);
        this.table.setAutoResizeMode(0);
        this.scroll.setViewportView(this.table);
    }

    public void setTimedPermissions(TimedPermissionsInterface timedPermissions) {
        this.timedPermissions = timedPermissions;
    }

    private void init() {
        this.dateSelector = this.getDateSelector();
        this.tm = this.buildTableModel();
        this.table = new SortableTable(this.tm, this);
        this.totalPanel = this.buildTotalPanel();
        this.customParamsPanel = this.buildCustomParamsPanel();
        this.raport = new JButton("Raport");
        this.raport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractReportPanel.this.raport();
            }
        });
        this.preview = new JButton("Preview");
        this.preview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = "Preview " + AbstractReportPanel.this.getName();
                if (AbstractReportPanel.this.userLogInterface != null) {
                    AbstractReportPanel.this.userLogInterface.addBOUserLogCommit(text);
                }
                AbstractReportPanel.this.preview();
            }
        });
        this.print = new JButton(LangRoAll.print);
        this.print.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = "Print " + AbstractReportPanel.this.getName();
                if (AbstractReportPanel.this.userLogInterface != null) {
                    AbstractReportPanel.this.userLogInterface.addBOUserLogCommit(text);
                }
                AbstractReportPanel.this.print();
            }
        });
        this.excel = new JButton("Excel");
        this.excel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = "Excel " + AbstractReportPanel.this.getName();
                if (AbstractReportPanel.this.userLogInterface != null) {
                    AbstractReportPanel.this.userLogInterface.addBOUserLogCommit(text);
                }
                AbstractReportPanel.this.excel();
            }
        });
        this.xml = new JButton("Xml");
        this.xml.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = "Xml " + AbstractReportPanel.this.getName();
                if (AbstractReportPanel.this.userLogInterface != null) {
                    AbstractReportPanel.this.userLogInterface.addBOUserLogCommit(text);
                }
                AbstractReportPanel.this.xml();
            }
        });
        this.dbf = new JButton("Dbf");
        this.dbf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = "Dbf " + AbstractReportPanel.this.getName();
                if (AbstractReportPanel.this.userLogInterface != null) {
                    AbstractReportPanel.this.userLogInterface.addBOUserLogCommit(text);
                }
                AbstractReportPanel.this.dbf();
            }
        });
    }

    public DateSelectorInterface getDateSelector() {
        DateSelector d = new DateSelector();
        return d;
    }

    private JPanel getParametersPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.gridheight = 2;
        c.anchor = 17;
        if (this.customParamsPanel != null) {
            result.add((Component)this.customParamsPanel, c);
        } else {
            result.add((Component)new JLabel(""), c);
        }
        ++c.gridx;
        c.weightx = 0.0;
        c.anchor = 13;
        c.gridheight = 1;
        if (this.dateSelector != null) {
            result.add((Component)this.dateSelector.getPanel(), c);
        } else {
            result.add((Component)new JLabel(""), c);
        }
        ++c.gridy;
        if (this.showRefreshPanel()) {
            JPanel refreshPanel = this.getRefreshPanel();
            result.add((Component)refreshPanel, c);
        } else {
            result.add((Component)new JLabel(), c);
        }
        result.setBorder(new TitledBorder("Parametri"));
        return result;
    }

    private JPanel getButtonsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.fill = 2;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)this.raport, c);
        ++c.gridy;
        result.add((Component)this.preview, c);
        ++c.gridy;
        result.add((Component)this.print, c);
        ++c.gridy;
        result.add((Component)this.excel, c);
        if (this.showXmlButton()) {
            ++c.gridy;
            result.add((Component)this.xml, c);
        }
        if (this.showDbfButton()) {
            ++c.gridy;
            result.add((Component)this.dbf, c);
        }
        return result;
    }

    protected void finalize() throws Throwable {
        this.refreshThreadRunning = false;
    }

    private JPanel getRefreshPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(2, 2, 2, 2);
        return result;
    }

    public boolean showRefreshPanel() {
        return true;
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(1, 2, 1, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 1;
        this.add((Component)this.getParametersPanel(), c);
        ++c.gridx;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.anchor = 13;
        c.fill = 2;
        JPanel buttons = this.getButtonsPanel();
        this.add((Component)buttons, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 1;
        this.scroll = new JScrollPane(this.table);
        this.add((Component)this.scroll, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        if (this.totalPanel != null) {
            if (this.totalPanelLabel()) {
                this.totalPanel.setBorder(new TitledBorder(LangRoAll.total));
            }
            this.add((Component)this.totalPanel, c);
        }
        try {
            if (Config.getInstance().getBoolean("piratMode")) {
                this.whatToPrint = 2;
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    protected boolean totalPanelLabel() {
        return true;
    }

    protected boolean verifyData() {
        if (this.data == null) {
            DialogUtils.errorDialog(this, "Date inexistente. Apasati butonul \"Raport\" si incercati din nou.", LangRoAll.nuPotContinua);
            return false;
        }
        return true;
    }

    private void excel() {
        String inputFile;
        if (this.verifyData() && (inputFile = FileDialog.getSaveDialogLocation(this, LangRoAll.alegetiFisierulDestinatie, "xls")) != null) {
            File f = new File(inputFile);
            this.writeExcel(f);
        }
    }

    public void raport() {
        Date startDate = null;
        Date stopDate = null;
        if (this.dateSelector != null) {
            Date[] dates = this.dateSelector.getDates();
            startDate = dates[0];
            stopDate = dates[1];
            if (startDate == null || stopDate == null) {
                DialogUtils.errorDialog(this, "Data este incorecta. Va rugam alegeti data", LangRoAll.nuPotContinua);
                return;
            }
        }
        if (this.timedPermissions != null && !this.timedPermissions.canView(new Timestamp(startDate.getTime()))) {
            DialogUtils.errorDialog(this, this.timedPermissions.getViewError(), LangRoAll.nuPotContinua);
            return;
        }
        if (this.timedPermissions != null && !this.timedPermissions.canView(new Timestamp(stopDate.getTime()))) {
            DialogUtils.errorDialog(this, this.timedPermissions.getViewError(), LangRoAll.nuPotContinua);
            return;
        }
        this.criteria = this.buildCriteria(startDate, stopDate);
        this.data = this.getResult(this.criteria);
        this.table.refresh(this.data);
        this.refreshTotalPanel();
        String text = "Raport " + this.getName() + " cu parametri: " + this.criteria.toString();
        if (this.userLogInterface != null) {
            this.userLogInterface.addBOUserLogCommit(text);
        }
        this.lastRefresh = System.currentTimeMillis();
    }

    public abstract Hashtable buildCriteria(Date var1, Date var2);

    private void print() {
        if (this.verifyData()) {
            this.printReport();
        }
    }

    private void preview() {
        if (this.verifyData()) {
            this.printPreview();
        }
    }

    private void xml() {
        if (this.verifyData()) {
            this.exportToXml();
        }
    }

    protected void dbf() {
        if (this.verifyData()) {
            this.exportToDbf();
        }
    }

    public void exportToDbf() {
        DialogUtils.errorDialog(this, LangRoAll.functieNeimplementata, LangRoAll.nuPotContinua);
    }

    public void exportToXml() {
        DialogUtils.errorDialog(this, LangRoAll.functieNeimplementata, LangRoAll.nuPotContinua);
    }

    public abstract void printReport();

    public abstract void printPreview();

    public abstract Vector getResult(Hashtable var1);

    public abstract void writeExcel(File var1);

    @Override
    public abstract String getName();

    public abstract AbstractTM buildTableModel();

    public abstract JPanel buildTotalPanel();

    public abstract JPanel buildCustomParamsPanel();

    public abstract void refreshTotalPanel();

    public boolean showXmlButton() {
        return false;
    }

    public boolean showDbfButton() {
        return false;
    }
}

