/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.sql;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;

public class SqlUtils {
    public static Object coalesce(ResultSet rs, String column, Object d) {
        Object result = d;
        try {
            result = rs.getObject(column);
            if (result == null) {
                result = d;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void executeSQLFromFile(String inputFile, Connection connection) throws SQLException {
        try {
            FileInputStream stream = new FileInputStream(inputFile);
            SqlUtils.executeSQLFromFile(stream, connection);
        }
        catch (IOException e) {
            Logger.logException("SqlUtils", (Exception)e);
        }
    }

    public static void executeSQLFromFile(InputStream inputStream, Connection connection) throws SQLException {
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(inputStream));
        try {
            StringBuffer currentSQl = new StringBuffer();
            String read = reader.readLine();
            while (read != null) {
                int commentIndex = (read = read.trim()).indexOf("--");
                if (commentIndex > 0) {
                    read = read.substring(0, commentIndex);
                }
                if ((commentIndex = read.indexOf("//")) >= 0) {
                    read = read.substring(0, commentIndex);
                }
                if (Validators.correctString(read)) {
                    read = " " + read + " ";
                    int index = read.indexOf(";");
                    if (index != -1) {
                        currentSQl.append(read.substring(0, index));
                        SqlUtils.executeUpdate(currentSQl.toString(), connection);
                        currentSQl.delete(0, currentSQl.length());
                    } else {
                        currentSQl.append(read + " ");
                    }
                }
                read = reader.readLine();
            }
        }
        catch (IOException e) {
            Logger.logException("SqlUtils", (Exception)e);
        }
    }

    public static ResultSet executeQuery(String query, Connection connection) throws SQLException {
        ResultSet result = null;
        Statement s = connection.createStatement();
        System.out.println(query);
        result = s.executeQuery(query);
        return result;
    }

    public static boolean executeUpdate(String update, Connection connection) throws SQLException {
        Statement s = connection.createStatement();
        s.executeUpdate(update);
        s.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean executeUpdateType2(String update, Connection connection) throws SQLException {
        Statement s = null;
        try {
            s = connection.createStatement();
            s.executeUpdate(update);
        }
        catch (SQLException e) {
            Logger.logException(SqlUtils.class.getName(), (Exception)e);
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    public static void executeSQLFromResourceFile(String file, Connection connection) throws SQLException {
        SqlUtils.executeSQLFromFile(Utils.getResource(file), connection);
    }

    public static int executeInsert(String sql, Connection connection) throws SQLException {
        int key = -1;
        Statement s = connection.createStatement();
        s.execute(sql, 1);
        ResultSet rs = s.getGeneratedKeys();
        if (rs.next()) {
            key = rs.getInt(1);
        }
        rs.close();
        return key;
    }

    public static int getGeneratedKey(Statement s) throws SQLException {
        int key = -1;
        ResultSet rs = s.getGeneratedKeys();
        if (rs.next()) {
            key = rs.getInt(1);
        }
        rs.close();
        return key;
    }

    public static String replace(String orgStr, String oldStr, String newStr) {
        return orgStr.replace(oldStr, newStr);
    }
}

