/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.tags;

import java.sql.SQLException;
import java.util.Vector;
import ro.atreides.utils.EventGenerator;
import ro.atreides.utils.Logger;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.tags.Tag;
import ro.atreides.utils.tags.db.TagsImpl;

public class TagsLogic
extends EventGenerator {
    private static TagsLogic instance;
    private ConnectionPool pool = ConnectionPool.getInstance();

    public static synchronized TagsLogic getInstance() {
        if (instance == null) {
            instance = new TagsLogic();
        }
        return instance;
    }

    private synchronized TagsImpl getTagsImpl() {
        ConnectionWrapper connection = this.pool.requestConnection();
        TagsImpl dao = null;
        while (dao == null) {
            dao = (TagsImpl)this.pool.getDao(TagsImpl.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(TagsImpl.class.getName(), connection);
        }
        return dao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTag(Tag tag) {
        try {
            this.getTagsImpl().addTag(tag);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTag(Tag tag) {
        try {
            this.getTagsImpl().deleteTag(tag);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTag(Tag tag) {
        try {
            this.getTagsImpl().updateTag(tag);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Tag> getAllTags() {
        try {
            Vector<Tag> vector = this.getTagsImpl().getAllTags();
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<Tag> vector = new Vector<Tag>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tag getTagById(int idTag) {
        try {
            Tag tag = this.getTagsImpl().getTagById(idTag);
            return tag;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Tag tag = null;
            return tag;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tag getTagByName(String name) {
        try {
            Tag tag = this.getTagsImpl().getTagByName(name);
            return tag;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Tag tag = null;
            return tag;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIntoStocksTags(int idStock, Tag tag) {
        try {
            this.getTagsImpl().addIntoStocksTags(idStock, tag.getId());
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Tag> getAllStocksTags(int idStock) {
        try {
            Vector<Tag> vector = this.getTagsImpl().getAllTagsOfStock(idStock);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<Tag> vector = new Vector<Tag>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFromStocksTags(int idStock, Tag tag) {
        try {
            this.getTagsImpl().deleteFromStocksTags(idStock, tag.getId());
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTagsToStock(int idStock, Vector<Tag> tagsToSave) {
        try {
            Vector<Tag> tagsOfStock = this.getTagsImpl().getAllTagsOfStock(idStock);
            for (Tag tag : tagsToSave) {
                if (tagsOfStock.contains(tag)) continue;
                this.getTagsImpl().addIntoStocksTags(idStock, tag.getId());
            }
            for (Tag tag : tagsOfStock) {
                if (tagsToSave.contains(tag)) continue;
                this.getTagsImpl().deleteFromStocksTags(idStock, tag.getId());
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }
}

