/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.tags.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import ro.atreides.utils.db.DaoInterface;
import ro.atreides.utils.tags.Tag;

public class TagsImpl
implements DaoInterface {
    private PreparedStatement addTag;
    private PreparedStatement deleteTag;
    private PreparedStatement updateTag;
    private PreparedStatement getAllTags;
    private PreparedStatement getTagById;
    private PreparedStatement getTagByName;
    private PreparedStatement addIntoStocksTags;
    private PreparedStatement getAllTagsOfStock;
    private PreparedStatement deleteFromStocksTags;
    private Connection connection;

    public TagsImpl(Connection conn) throws SQLException {
        this.connection = conn;
        this.buildPreparedStatements();
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.addTag = this.connection.prepareStatement("insert into tags (label) VALUES (?)");
        this.deleteTag = this.connection.prepareStatement("delete from tags where id = ?");
        this.updateTag = this.connection.prepareStatement("update tags set label = ? where id = ?");
        this.getAllTags = this.connection.prepareStatement("select * from tags");
        this.getTagById = this.connection.prepareStatement("select * from tags where id = ?");
        this.getTagByName = this.connection.prepareStatement("select * from tags where label = ?");
        this.addIntoStocksTags = this.connection.prepareStatement("insert into stocks_tags (id_stock, id_tag) VALUES (?, ?)");
        this.getAllTagsOfStock = this.connection.prepareStatement("select tags.* from stocks_tags inner join tags on tags.id = stocks_tags.id_tag where stocks_tags.id_stock = ?");
        this.deleteFromStocksTags = this.connection.prepareStatement("delete from stocks_tags where id_stock = ? and id_tag = ?");
    }

    private Tag getTagFromRS(ResultSet rs) throws SQLException {
        int id = rs.getInt("id");
        String label = rs.getString("label");
        Tag result = new Tag(id, label);
        return result;
    }

    public void addTag(Tag tag) throws SQLException {
        this.addTag.setString(1, tag.getLabel());
        this.addTag.execute();
    }

    public void deleteTag(Tag tag) throws SQLException {
        this.deleteTag.setInt(1, tag.getId());
        this.deleteTag.execute();
    }

    public void updateTag(Tag tag) throws SQLException {
        this.updateTag.setString(1, tag.getLabel());
        this.updateTag.setInt(2, tag.getId());
        this.updateTag.executeUpdate();
    }

    public Vector<Tag> getAllTags() throws SQLException {
        Vector<Tag> tags = new Vector<Tag>();
        ResultSet rs = this.getAllTags.executeQuery();
        while (rs.next()) {
            Tag tag = this.getTagFromRS(rs);
            tags.add(tag);
        }
        rs.close();
        return tags;
    }

    public Tag getTagById(int idTag) throws SQLException {
        Tag tag = null;
        this.getTagById.setInt(1, idTag);
        ResultSet rs = this.getTagById.executeQuery();
        if (rs.next()) {
            tag = this.getTagFromRS(rs);
        }
        rs.close();
        return tag;
    }

    public Tag getTagByName(String name) throws SQLException {
        Tag tag = null;
        this.getTagByName.setString(1, name);
        ResultSet rs = this.getTagByName.executeQuery();
        if (rs.next()) {
            tag = this.getTagFromRS(rs);
        }
        rs.close();
        return tag;
    }

    public void addIntoStocksTags(int idStock, int idTag) throws SQLException {
        this.addIntoStocksTags.setInt(1, idStock);
        this.addIntoStocksTags.setInt(2, idTag);
        this.addIntoStocksTags.execute();
    }

    public Vector<Tag> getAllTagsOfStock(int idStock) throws SQLException {
        Vector<Tag> result = new Vector<Tag>();
        this.getAllTagsOfStock.setInt(1, idStock);
        ResultSet rs = this.getAllTagsOfStock.executeQuery();
        while (rs.next()) {
            Tag tag = this.getTagFromRS(rs);
            result.add(tag);
        }
        rs.close();
        return result;
    }

    public void deleteFromStocksTags(int idStock, Integer idTag) throws SQLException {
        this.deleteFromStocksTags.setInt(1, idStock);
        this.deleteFromStocksTags.setInt(2, idTag);
        this.deleteFromStocksTags.execute();
    }
}

