/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.tags.gui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.Constants;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.tags.Tag;
import ro.atreides.utils.tags.TagsLogic;

public class TagsPanel
extends AbstractListPanel {
    @Override
    public AbstractTM buildTableModel() {
        AbstractTM tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                Tag tag = (Tag)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return tag.getLabel();
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        return tm;
    }

    @Override
    public JPanel getBottomPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout("fill"));
        final TagsPanel parent = this;
        JLabel label = new JLabel(LangRoAll.tags);
        result.add((Component)label, "growx");
        final JTextField tagLabel = new JTextField();
        result.add((Component)tagLabel, "growx");
        JButton adauga = new JButton(LangRoAll.adauga);
        adauga.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = tagLabel.getText();
                if (Validators.correctString(text)) {
                    Tag tag = new Tag();
                    tag.setLabel(text);
                    TagsLogic.getInstance().addTag(tag);
                    TagsPanel.this.refreshTable();
                    tagLabel.setText("");
                    tagLabel.requestFocus();
                    StockLogic.getInstance().notifyListeners(Constants.TAGS_CHANGED);
                } else {
                    DialogUtils.errorDialog(parent, LangRoAll.tagCompletati, LangRoAll.nuPotContinua);
                    tagLabel.requestFocus();
                }
            }
        });
        result.add((Component)adauga, "growx");
        result.setBorder(new TitledBorder(LangRoAll.tags));
        return result;
    }

    @Override
    public Vector buildData() {
        return TagsLogic.getInstance().getAllTags();
    }

    @Override
    public String[] buildColumns() {
        return new String[]{LangRoAll.tags};
    }

    @Override
    public Class[] buildTypes() {
        return Utils.getStringClass(this.buildColumns().length);
    }

    @Override
    public void doStuff() {
        this.display();
    }
}

