/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.tva;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.tva.Tva;
import ro.atreides.utils.tva.TvaLogic;

public class TvaPanel
extends AbstractListPanel {
    private JTextField cotaText;
    private JTextField codText;
    private Tva editableTva;

    @Override
    public String[] buildColumns() {
        return new String[]{LangRoAll.cotaTva, LangRoAll.codCasaMarcat};
    }

    @Override
    public Vector buildData() {
        return TvaLogic.getInstance().getTvas();
    }

    @Override
    public Class[] buildTypes() {
        return Utils.getStringClass(this.buildColumns().length);
    }

    @Override
    public JPanel getBottomPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 0;
        c.weightx = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 0, 2, 0);
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.cotaTva), c);
        ++c.gridx;
        this.cotaText = new JTextField(10);
        result.add((Component)this.cotaText, c);
        ++c.gridx;
        result.add((Component)new JLabel(LangRoAll.codCasaMarcat), c);
        ++c.gridx;
        this.codText = new JTextField(10);
        result.add((Component)this.codText, c);
        final TvaPanel parent = this;
        ++c.gridx;
        JButton salveaza = new JButton(LangRoAll.salveaza);
        salveaza.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String cota = TvaPanel.this.cotaText.getText();
                String cod = TvaPanel.this.codText.getText();
                if (Validators.correctDouble(cota) && Validators.correctString(cod)) {
                    double f = Utils.parseDouble(cota);
                    if (TvaPanel.this.editableTva == null) {
                        TvaLogic.getInstance().addTva(f, cod);
                    } else {
                        TvaPanel.this.editableTva.setCodCasa(cod);
                        TvaPanel.this.editableTva.setCota(f);
                        TvaLogic.getInstance().updateTva(TvaPanel.this.editableTva);
                    }
                    TvaPanel.this.refreshTable();
                    TvaPanel.this.setTvaToEdit(null);
                    TvaPanel.this.cotaText.requestFocus();
                } else {
                    DialogUtils.errorDialog(parent, LangRoAll.completatiCorectCampurile, LangRoAll.nuPotContinua);
                }
            }
        });
        result.add((Component)salveaza, c);
        ++c.gridx;
        JButton sterge = new JButton(LangRoAll.sterge);
        sterge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogUtils.confirmDialog(parent, LangRoAll.stergemCotaTva, LangRoAll.confirmare)) {
                    TvaLogic.getInstance().deleteTva(TvaPanel.this.editableTva);
                }
                TvaPanel.this.refreshTable();
                TvaPanel.this.setTvaToEdit(null);
                TvaPanel.this.cotaText.requestFocus();
            }
        });
        result.add((Component)sterge, c);
        result.setBorder(new TitledBorder(LangRoAll.actiuni));
        return result;
    }

    public void setTvaToEdit(Tva tva) {
        String cota = "";
        String cod = "";
        if (tva != null) {
            cota = Utils.getString2Decimals(tva.getCota());
            cod = tva.getCodCasa();
        }
        this.cotaText.setText(cota);
        this.codText.setText(cod);
        this.editableTva = tva;
    }

    @Override
    public AbstractTM buildTableModel() {
        return new AbstractTM(this.buildColumns(), new Class[]{String.class, String.class, Boolean.class, String.class, String.class, Boolean.class}, new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                Tva plata = (Tva)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return Utils.getString2Decimals(plata.getCota());
                    }
                    case 1: {
                        return plata.getCodCasa();
                    }
                }
                return null;
            }
        });
    }

    @Override
    public void doStuff() {
        this.display();
    }
}

